/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.data;

import java.util.Map;
import java.util.Optional;
import me.moros.bending.api.util.data.DataContainer;
import me.moros.bending.api.util.data.DataKey;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleDataContainer
implements DataContainer {
    private final Map<DataKey<?>, Object> data;

    SimpleDataContainer(Map<DataKey<?>, Object> data) {
        this.data = data;
    }

    @Override
    public <T> Optional<T> get(DataKey<T> key) {
        return Optional.ofNullable(this.cast(key.type(), this.data.get(key)));
    }

    @Override
    public <T> void add(DataKey<T> key, T value) {
        this.data.put(key, value);
    }

    @Override
    public <T> void remove(DataKey<T> key) {
        this.data.remove(key);
    }

    @Override
    public <T> boolean canEdit(DataKey<T> key) {
        return true;
    }

    @Override
    public <T extends Enum<T>> T toggle(DataKey<T> key, T defaultValue) {
        Enum oldValue = (Enum)this.cast(key.type(), this.data.computeIfAbsent(key, k -> defaultValue));
        if (oldValue != null && !this.canEdit(key)) {
            return (T)oldValue;
        }
        T newValue = this.toggle(oldValue == null ? defaultValue : oldValue);
        this.add(key, newValue);
        return newValue;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    private <T extends Enum<T>> T toggle(T oldValue) {
        Enum[] values = (Enum[])oldValue.getDeclaringClass().getEnumConstants();
        int index = (oldValue.ordinal() + 1) % values.length;
        return (T)values[index];
    }

    private <T> @Nullable T cast(Class<T> type, Object value) {
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }
}

