/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.AbilityInitializer;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class AirSwipe
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private final MultiUpdatable<AirStream> streams = MultiUpdatable.empty();
    private boolean charging;
    private double factor = 1.0;
    private long startTime;

    public AirSwipe(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.startTime = System.currentTimeMillis();
        this.charging = true;
        if (user.world().blockAt(user.mainHandSide()).type().isLiquid()) {
            return false;
        }
        for (AirSwipe swipe : user.game().abilityManager(user.worldKey()).userInstances(user, AirSwipe.class).toList()) {
            if (!swipe.charging) continue;
            swipe.launch();
            return false;
        }
        if (method == Activation.ATTACK) {
            this.launch();
        }
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.charging) {
            if (this.user.sneaking() && System.currentTimeMillis() >= this.startTime + this.userConfig.maxChargeTime) {
                ParticleBuilder.air(this.user.mainHandSide()).spawn(this.user.world());
            } else if (!this.user.sneaking()) {
                this.launch();
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.streams.update();
    }

    private void launch() {
        long deltaTime = System.currentTimeMillis() - this.startTime;
        this.factor = 1.0;
        if (deltaTime >= this.userConfig.maxChargeTime) {
            this.factor = this.userConfig.chargeFactor;
        } else if ((double)deltaTime > 0.3 * (double)this.userConfig.maxChargeTime) {
            double deltaFactor = (this.userConfig.chargeFactor - this.factor) * (double)deltaTime / (double)this.userConfig.maxChargeTime;
            this.factor += deltaFactor;
        }
        this.charging = false;
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        Vector3d origin = this.user.mainHandSide();
        Vector3d dir = this.user.direction();
        Vector3d rotateAxis = dir.cross(Vector3d.PLUS_J).normalize().cross(dir);
        int steps = this.userConfig.arc / 5;
        VectorUtil.createArc(dir, rotateAxis, 0.08726646259971647, steps).forEach(v -> this.streams.add(new AirStream(Ray.of(origin, (Vector3d)v.multiply(this.userConfig.range * this.factor)))));
        this.removalPolicy = Policies.defaults();
    }

    @Override
    public void onCollision(Collision collision) {
        Ability collidedAbility = collision.collidedAbility();
        if (Math.abs(this.factor - this.userConfig.chargeFactor) < 0.001 && collision.removeSelf()) {
            if (AbilityInitializer.layer2.containsValue(collidedAbility.description().key())) {
                collision.removeOther(true);
            } else {
                collision.removeSelf(false);
            }
        }
        if (collidedAbility instanceof AirSwipe) {
            AirSwipe other = (AirSwipe)collidedAbility;
            if (this.factor > other.factor + 0.1) {
                collision.removeSelf(false);
            }
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(ParticleStream::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1500L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 9.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.8;
        private int arc = 35;
        @Comment(value="How many milliseconds it takes to fully charge")
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long maxChargeTime = 2000L;
        @Comment(value="How much the damage, range and knockback are multiplied by at full charge")
        @Modifiable(value=Attribute.STRENGTH)
        private double chargeFactor = 2.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airswipe");
        }
    }

    private class AirStream
    extends ParticleStream {
        public AirStream(Ray ray) {
            super(AirSwipe.this.user, ray, AirSwipe.this.userConfig.speed, 0.5);
            this.canCollide = b -> b.isLiquid() || MaterialUtil.isFire(b) || MaterialUtil.BREAKABLE_PLANTS.isTagged(b);
            this.livingOnly = false;
        }

        @Override
        public void render(Vector3d location) {
            ParticleBuilder.air(location).spawn(AirSwipe.this.user.world());
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.AIR_FAST.play(AirSwipe.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (AirSwipe.this.affectedEntities.add(entity.uuid())) {
                entity.damage(AirSwipe.this.userConfig.damage * AirSwipe.this.factor, AirSwipe.this.user, AirSwipe.this.description());
                Vector3d velocity = (Vector3d)((Vector3d)entity.center().subtract(this.ray.position())).normalize().multiply(AirSwipe.this.factor);
                entity.applyVelocity(AirSwipe.this, velocity);
                return true;
            }
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (WorldUtil.tryBreakPlant(block) || WorldUtil.tryExtinguishFire(AirSwipe.this.user, block)) {
                return false;
            }
            WorldUtil.tryCoolLava(AirSwipe.this.user, block);
            return true;
        }
    }
}

