/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.passive;

import java.util.List;
import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;

public class DensityShift
extends AbilityInstance {
    private Config userConfig;

    public DensityShift(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean isSoftened() {
        if (!this.user.canBend(this.description())) {
            return false;
        }
        Block block = this.user.block().offset(Direction.DOWN);
        if (EarthMaterials.isEarthbendable(this.user, block)) {
            this.softenArea();
            return true;
        }
        return MaterialUtil.isTransparent(block);
    }

    public static boolean isSoftened(User user) {
        return user.game().abilityManager(user.worldKey()).firstInstance(user, DensityShift.class).map(DensityShift::isSoftened).orElse(false);
    }

    private void softenArea() {
        Vector3d center = this.user.block().offset(Direction.DOWN).center();
        Predicate<Block> predicate = b -> EarthMaterials.isEarthOrSand(b) && !b.offset(Direction.UP).type().isCollidable();
        for (Block b2 : this.user.world().nearbyBlocks(center, this.userConfig.radius, predicate)) {
            if (MaterialUtil.isAir(b2.offset(Direction.DOWN)) || !TempBlock.isBendable(b2)) continue;
            TempBlock.builder(MaterialUtil.softType(b2.type())).bendable(true).weak(true).duration(this.userConfig.duration).build(b2);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.DURATION)
        private long duration = 6000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 2.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "passives", "densityshift");
        }
    }
}

