/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.util;

import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.Vector3d;

public class Projectile
extends AbilityInstance {
    private static final AABB BOX = AABB.BLOCK_BOUNDS.grow(Vector3d.of(0.25, 0.25, 0.25));
    private final RemovalPolicy removalPolicy;
    private final TempEntity.TempFallingBlock projectile;
    private final double damage;
    private Vector3d location;

    public Projectile(User user, AbilityDescription desc, TempEntity.TempFallingBlock projectile, double range, double damage) {
        super(desc);
        this.user = user;
        this.projectile = projectile;
        this.damage = damage;
        this.location = projectile.center();
        this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(range, this.location, () -> this.location)).build();
    }

    @Override
    public boolean activate(User user, Activation method) {
        return false;
    }

    @Override
    public void loadConfig() {
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || !this.projectile.valid()) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.location = this.projectile.center();
        if (CollisionUtil.handle(this.user, BOX.at(this.location), this::onProjectileHit)) {
            this.projectile.state().asParticle(this.location).count(8).offset(0.25, 0.15, 0.25).spawn(this.user.world());
            return Updatable.UpdateResult.REMOVE;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        this.projectile.revert();
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(BOX.at(this.location));
    }

    private boolean onProjectileHit(Entity entity) {
        BlockType mat = this.projectile.state().type();
        double modifiedDamage = EarthMaterials.METAL_BENDABLE.isTagged(mat) ? BendingProperties.instance().metalModifier(this.damage) : (EarthMaterials.LAVA_BENDABLE.isTagged(mat) ? BendingProperties.instance().magmaModifier(this.damage) : this.damage);
        entity.applyVelocity(this, (Vector3d)this.projectile.velocity().normalize().multiply(0.4));
        entity.damage(modifiedDamage, this.user, this.description());
        return true;
    }
}

