/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire.sequence;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class FireKick
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private final MultiUpdatable<FireStream> streams = MultiUpdatable.empty();

    public FireKick(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        double height = user.eyeHeight();
        Vector3d direction = ((Vector3d)user.direction().multiply(this.userConfig.range)).add(0.0, height, 0.0).normalize();
        Vector3d origin = user.location();
        Vector3d dir = user.direction();
        Vector3d rotateAxis = dir.cross(Vector3d.PLUS_J).normalize().cross(dir);
        VectorUtil.createArc(direction, rotateAxis, 0.10471975511965977, 11).forEach(v -> this.streams.add(new FireStream(Ray.of(origin, (Vector3d)v.multiply(this.userConfig.range)))));
        this.removalPolicy = Policies.defaults();
        user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.streams.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(ParticleStream::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 4000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.FIRE_TICKS)
        private int fireTicks = 25;
        @Modifiable(value=Attribute.RANGE)
        private double range = 7.0;
        @Comment(value="How many blocks the streams advance with each tick.")
        @Modifiable(value=Attribute.SPEED)
        private double speed = 1.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "sequences", "firekick");
        }
    }

    private class FireStream
    extends ParticleStream {
        private int ticks;

        public FireStream(Ray ray) {
            super(FireKick.this.user, ray, FireKick.this.userConfig.speed, 0.5);
            this.ticks = 3;
            this.canCollide = BlockProperties::isLiquid;
        }

        @Override
        public void render(Vector3d location) {
            ParticleBuilder.fire(FireKick.this.user, location).count(4).offset(0.15).extra(0.01).spawn(FireKick.this.user.world());
            TempLight.builder(++this.ticks).build(FireKick.this.user.world().blockAt(location));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.FIRE.play(FireKick.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (FireKick.this.affectedEntities.add(entity.uuid())) {
                BendingEffect.FIRE_TICK.apply(FireKick.this.user, entity, FireKick.this.userConfig.fireTicks);
                entity.damage(FireKick.this.userConfig.damage, FireKick.this.user, FireKick.this.description());
            }
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            FragileStructure.tryDamageStructure(block, 3, Ray.of(this.collider().position(), this.ray.direction()));
            return true;
        }
    }
}

