/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire.sequence;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractWheel;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class FireWheel
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Wheel wheel;

    public FireWheel(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        Vector3d direction = ((Vector3d)user.direction().withY(0.0)).normalize();
        Vector3d location = (Vector3d)user.location().add(direction);
        location = location.add(0.0, this.userConfig.radius, 0.0);
        if (user.world().blockAt(location).type().isLiquid()) {
            return false;
        }
        this.wheel = new Wheel(Ray.of(location, direction));
        if (!this.wheel.resolveMovement()) {
            return false;
        }
        this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(this.userConfig.range, location, () -> this.wheel.location())).build();
        user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.wheel.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.wheel.collider());
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 8000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 1.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.FIRE_TICKS)
        private int fireTicks = 25;
        @Modifiable(value=Attribute.RANGE)
        private double range = 25.0;
        @Comment(value="How many blocks the wheel advances every tick")
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.75;
        private boolean fireTrail = true;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "sequences", "firewheel");
        }
    }

    private class Wheel
    extends AbstractWheel {
        public Wheel(Ray ray) {
            super(FireWheel.this.user, ray, FireWheel.this.userConfig.radius, FireWheel.this.userConfig.speed);
        }

        @Override
        public void render(Vector3d location) {
            Vector3d rotateAxis = Vector3d.PLUS_J.cross(this.ray.direction());
            VectorUtil.circle((Vector3d)this.ray.direction().multiply(this.radius), rotateAxis, 36).forEach(v -> ParticleBuilder.fire(FireWheel.this.user, location.add((Position)v)).extra(0.01).spawn(FireWheel.this.user.world()));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.FIRE.play(FireWheel.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            BendingEffect.FIRE_TICK.apply(FireWheel.this.user, entity, FireWheel.this.userConfig.fireTicks);
            entity.damage(FireWheel.this.userConfig.damage, FireWheel.this.user, FireWheel.this.description());
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (FireWheel.this.userConfig.fireTrail && MaterialUtil.isIgnitable(block) && FireWheel.this.user.canBuild(block)) {
                TempBlock.fire().duration(BendingProperties.instance().fireRevertTime()).ability(FireWheel.this).build(block);
            }
            return true;
        }
    }
}

