/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.common.basic.BlockShot;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.Vector3d;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class WaterManipulation
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private Manip manip;
    private final Deque<Block> trail = new ArrayDeque<Block>(2);
    private boolean isIce;

    public WaterManipulation(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        if (method == Activation.ATTACK) {
            List<WaterManipulation> manips = user.game().abilityManager(user.worldKey()).userInstances(user, WaterManipulation.class).toList();
            WaterManipulation.redirectAny(user, this.userConfig);
            for (WaterManipulation manip : manips) {
                if (manip.manip == null) {
                    manip.launch();
                    continue;
                }
                manip.manip.redirect();
            }
            return false;
        }
        Block source = user.find(this.userConfig.selectRange, WaterMaterials::isWaterBendable);
        if (source == null) {
            return false;
        }
        List<WaterManipulation> manips = user.game().abilityManager(user.worldKey()).userInstances(user, WaterManipulation.class).filter(m -> m.manip == null).toList();
        for (WaterManipulation manip : manips) {
            State state = manip.states.current();
            if (!(state instanceof SelectedSource)) continue;
            SelectedSource selectedSource = (SelectedSource)state;
            selectedSource.reselect(source);
            return false;
        }
        this.states = new StateChain().addState(SelectedSource.create(user, source, this.userConfig.selectRange)).start();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.manip == null ? this.states.update() : this.manip.update();
    }

    private void renderTrail(@Nullable Block block, int level) {
        if (block == null) {
            return;
        }
        if (MaterialUtil.isTransparentOrWater(block)) {
            WorldUtil.tryBreakPlant(block);
            if (!MaterialUtil.isWater(block)) {
                TempBlock.builder(MaterialUtil.waterData(level)).build(block);
            }
        }
    }

    private void launch() {
        if (this.user.onCooldown(this.description())) {
            return;
        }
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            state.complete();
            Block source = this.states.chainStore().stream().findAny().orElse(null);
            if (source == null || !TempBlock.isBendable(source)) {
                return;
            }
            if (WaterMaterials.isWaterBendable(source)) {
                this.isIce = WaterMaterials.isIceBendable(source);
                this.manip = new Manip(source);
                this.removalPolicy = Policies.defaults();
                this.user.addCooldown(this.description(), this.userConfig.cooldown);
                TempBlock.air().build(source);
            }
        }
    }

    private static void redirectAny(User user, Config config) {
        List<WaterManipulation> manips = user.game().abilityManager(user.worldKey()).instances(WaterManipulation.class).filter(m -> m.manip != null && !user.equals(m.user)).toList();
        Ray ray = user.ray(config.maxRedirectRange + 2.0);
        double minSq = config.noRedirectRange * config.noRedirectRange;
        double maxSq = config.maxRedirectRange * config.maxRedirectRange;
        for (WaterManipulation manip : manips) {
            Sphere selectSphere;
            Vector3d center = manip.manip.center();
            double dist = center.distance(manip.user().eyeLocation());
            if (dist * dist < minSq || center.distanceSq(user.eyeLocation()) > maxSq || !(selectSphere = Sphere.of(center, config.redirectGrabRadius)).intersects(ray)) continue;
            Vector3d direction = (Vector3d)center.subtract(user.eyeLocation());
            double range = Math.min(1.0, direction.length());
            Block rayTraced = user.rayTrace(range).direction(direction).ignoreLiquids(false).blocks(user.world()).block();
            if (!user.world().blockAt(center).equals(rayTraced)) continue;
            user.game().abilityManager(user.worldKey()).changeOwner(manip, user);
            manip.manip.redirect();
        }
    }

    @Override
    public void onDestroy() {
        if (this.manip != null) {
            this.trail.forEach(this.manip::clean);
            this.manip.clean();
        }
    }

    @Override
    public void onUserChange(User newUser) {
        this.user = newUser;
        this.manip.user(newUser);
    }

    @Override
    public Collection<Collider> colliders() {
        return this.manip == null ? List.of() : List.of(this.manip.collider());
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 24.0;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 12.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.FREEZE_TICKS)
        private int freezeTicks = 60;
        private double redirectGrabRadius = 2.0;
        @Comment(value="Manips within that distance from the bender who controls them cannot be redirected")
        private double noRedirectRange = 5.0;
        private double maxRedirectRange = 20.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "watermanipulation");
        }
    }

    private class Manip
    extends BlockShot {
        public Manip(Block block) {
            super(WaterManipulation.this.user, block, WaterManipulation.this.isIce ? block.type() : BlockType.WATER, WaterManipulation.this.userConfig.range, WaterManipulation.this.isIce ? 16 : 20);
            this.allowUnderWater = true;
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(5) == 0) {
                SoundEffect effect = WaterManipulation.this.isIce ? SoundEffect.ICE : SoundEffect.WATER;
                effect.play(WaterManipulation.this.user.world(), location);
            }
            if (WaterManipulation.this.isIce) {
                Particle.ITEM_SNOWBALL.builder(location).count(8).offset(0.4).spawn(WaterManipulation.this.user.world());
            } else {
                Block trail1 = this.previousBlock();
                if (trail1 != null) {
                    if (!WaterManipulation.this.trail.isEmpty()) {
                        this.clean(WaterManipulation.this.trail.peekFirst());
                    }
                    if (WaterManipulation.this.trail.size() == 2) {
                        this.clean(WaterManipulation.this.trail.removeLast());
                    }
                    WaterManipulation.this.trail.addFirst(trail1);
                    WaterManipulation.this.renderTrail(trail1, 7);
                    WaterManipulation.this.renderTrail(WaterManipulation.this.trail.peekLast(), 6);
                }
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (WaterManipulation.this.isIce) {
                BendingEffect.FROST_TICK.apply(WaterManipulation.this.user, entity, WaterManipulation.this.userConfig.freezeTicks);
            }
            entity.damage(WaterManipulation.this.userConfig.damage, WaterManipulation.this.user, WaterManipulation.this.description());
            entity.applyVelocity(WaterManipulation.this, (Vector3d)this.direction.multiply(0.5));
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            FragileStructure.tryDamageStructure(block, 3, Ray.of(this.center(), this.direction));
            return true;
        }
    }
}

