/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;

public class WaterWave
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private boolean ice = false;
    private long startTime;

    public WaterWave(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.PASSIVE) {
            return false;
        }
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, WaterWave.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.canBuild()) {
            return Updatable.UpdateResult.REMOVE;
        }
        double factor = 1.0 - (double)(System.currentTimeMillis() - this.startTime) / (double)this.userConfig.duration;
        this.user.applyVelocity(this, (Vector3d)this.user.direction().multiply(this.userConfig.speed * factor));
        this.user.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
        Vector3d center = (Vector3d)this.user.location().add(Vector3d.MINUS_J);
        ArrayList<TempBlock> toRevert = new ArrayList<TempBlock>();
        for (Block block : this.user.world().nearbyBlocks(center, this.userConfig.radius, MaterialUtil::isTransparent)) {
            if (TempBlock.MANAGER.isTemp(block) || !this.user.canBuild(block)) continue;
            TempBlock.water().duration(1500L).build(block).ifPresent(toRevert::add);
        }
        this.scheduleRevert(toRevert);
        if (this.ice) {
            CollisionUtil.handle(this.user, Sphere.of(center, this.userConfig.radius), this::onEntityHit);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void scheduleRevert(Iterable<TempBlock> tempBlocks) {
        Tasker.sync().submit(() -> {
            Consumer<TempBlock> consumer;
            if (this.ice) {
                TempBlock.Builder builder = TempBlock.ice().bendable(false).duration(1000L);
                consumer = tb -> builder.build(tb.block());
            } else {
                consumer = TempBlock::revert;
            }
            tempBlocks.forEach(consumer);
        }, 20);
    }

    private boolean onEntityHit(Entity entity) {
        if (this.affectedEntities.add(entity.uuid())) {
            BendingEffect.FROST_TICK.apply(this.user, entity, this.userConfig.freezeTicks);
            entity.damage(this.userConfig.iceDamage, this.user, this.description());
            return true;
        }
        return false;
    }

    public void freeze() {
        this.ice = true;
    }

    public static void freeze(User user) {
        if (user.hasAbilitySelected("phasechange")) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, WaterWave.class).ifPresent(WaterWave::freeze);
        }
    }

    @Override
    public void onDestroy() {
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 3500L;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 1.2;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 1.7;
        @Modifiable(value=Attribute.DAMAGE)
        private double iceDamage = 2.0;
        @Modifiable(value=Attribute.FREEZE_TICKS)
        private int freezeTicks = 100;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "waterring", "waterwave");
        }
    }
}

