/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.moros.bending.api.adapter.PacketUtil;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.display.Display;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.common.adapter.DisplayUtil;
import me.moros.bending.common.adapter.EntityDataBuilder;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractPacketUtil
implements PacketUtil {
    private final PlayerList playerList;
    private static final ResourceLocation ADVANCEMENT_KEY = ResourceLocation.fromNamespaceAndPath((String)"bending", (String)"notification");

    protected AbstractPacketUtil(PlayerList playerList) {
        this.playerList = playerList;
    }

    protected PlayerList playerList() {
        return this.playerList;
    }

    protected abstract ServerLevel adapt(World var1);

    protected abstract net.minecraft.world.level.block.state.BlockState adapt(BlockState var1);

    protected abstract Entity adapt(me.moros.bending.api.platform.entity.Entity var1);

    protected abstract ItemStack adapt(Item var1);

    protected abstract net.minecraft.network.chat.Component adapt(Component var1);

    protected abstract int nextEntityId();

    @Override
    public PacketUtil.ClientboundPacket createNotification(Item item, Component title) {
        return this.wrap((Packet<?>)new ClientboundBundlePacket(List.of(this.createNotificationPacket(item, title), this.clearNotification())));
    }

    @Override
    public PacketUtil.ClientboundPacket fakeBlock(Position position, BlockState state) {
        return this.wrap((Packet<?>)this.fakeBlockPacket(position, this.adapt(state)));
    }

    @Override
    public PacketUtil.ClientboundPacket fakeBreak(Position position, byte progress) {
        return this.wrap((Packet<?>)this.fakeBreakPacket(position, progress));
    }

    @Override
    public PacketUtil.ClientboundPacket createFallingBlock(Position center, BlockState state, Vector3d velocity, boolean gravity) {
        int id = this.nextEntityId();
        ArrayList<Object> packets = new ArrayList<Object>();
        int blockDataId = Block.getId((net.minecraft.world.level.block.state.BlockState)this.adapt(state));
        packets.add(this.createEntity(id, center, EntityType.FALLING_BLOCK, blockDataId));
        if (!gravity) {
            packets.add(new EntityDataBuilder(id).noGravity().build());
        }
        if (velocity.lengthSq() > 0.0) {
            packets.add(this.addVelocity(id, velocity));
        }
        return this.wrap(id, (Packet<?>)new ClientboundBundlePacket(packets));
    }

    @Override
    public PacketUtil.ClientboundPacket createDisplayEntity(Position center, Display<?> properties) {
        int id = this.nextEntityId();
        EntityDataBuilder builder = new EntityDataBuilder(id);
        EntityType<?> type = DisplayUtil.mapProperties(this, builder, properties);
        return this.wrap(id, (Packet<?>)new ClientboundBundlePacket(List.of(this.createEntity(id, center, type, 0), builder.build())));
    }

    @Override
    public PacketUtil.ClientboundPacket updateDisplayPosition(int id, Vector3d position) {
        return this.wrap(id, (Packet<?>)this.teleportEntity(id, position));
    }

    @Override
    public void destroy(int[] ids) {
        ClientboundRemoveEntitiesPacket packet = new ClientboundRemoveEntitiesPacket(ids);
        this.playerList().getPlayers().forEach(p -> p.connection.send((Packet)packet));
    }

    protected ClientboundUpdateAdvancementsPacket createNotificationPacket(Item item, Component title) {
        String criteriaId = "bending:criteria_progress";
        ItemStack icon = this.adapt(item);
        net.minecraft.network.chat.Component nmsTitle = this.adapt(title);
        MutableComponent nmsDesc = net.minecraft.network.chat.Component.empty();
        AdvancementType type = AdvancementType.TASK;
        Criterion criterion = CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
        AdvancementHolder advancement = new Advancement.Builder().display(icon, nmsTitle, (net.minecraft.network.chat.Component)nmsDesc, null, type, true, false, true).addCriterion(criteriaId, criterion).build(ADVANCEMENT_KEY);
        AdvancementProgress progress = new AdvancementProgress();
        progress.update(AdvancementRequirements.allOf(List.of(criteriaId)));
        progress.grantProgress(criteriaId);
        Map<ResourceLocation, AdvancementProgress> progressMap = Map.of(ADVANCEMENT_KEY, progress);
        return new ClientboundUpdateAdvancementsPacket(false, List.of(advancement), Set.of(), progressMap, true);
    }

    protected ClientboundUpdateAdvancementsPacket clearNotification() {
        return new ClientboundUpdateAdvancementsPacket(false, List.of(), Set.of(ADVANCEMENT_KEY), Map.of(), true);
    }

    protected ClientboundAddEntityPacket createEntity(int id, Position center, EntityType<?> type, int data) {
        double x = center.x();
        double y = center.y();
        double z = center.z();
        return new ClientboundAddEntityPacket(id, UUID.randomUUID(), x, y, z, 0.0f, 0.0f, type, data, Vec3.ZERO, 0.0);
    }

    protected ClientboundSetEntityMotionPacket addVelocity(int id, Vector3d vel) {
        return new ClientboundSetEntityMotionPacket(id, new Vec3(vel.x(), vel.y(), vel.z()));
    }

    protected ClientboundBlockUpdatePacket fakeBlockPacket(Position b, net.minecraft.world.level.block.state.BlockState state) {
        return new ClientboundBlockUpdatePacket(new BlockPos(b.blockX(), b.blockY(), b.blockZ()), state);
    }

    protected ClientboundBlockDestructionPacket fakeBreakPacket(Position b, byte progress) {
        int id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        return new ClientboundBlockDestructionPacket(id, new BlockPos(b.blockX(), b.blockY(), b.blockZ()), (int)progress);
    }

    protected ClientboundTeleportEntityPacket teleportEntity(int id, Position position) {
        Vec3 vec3 = new Vec3(position.x(), position.y(), position.z());
        PositionMoveRotation positionMoveRotation = new PositionMoveRotation(vec3, Vec3.ZERO, 0.0f, 0.0f);
        return ClientboundTeleportEntityPacket.teleport((int)id, (PositionMoveRotation)positionMoveRotation, Set.of(), (boolean)false);
    }

    protected PacketUtil.ClientboundPacket wrap(Packet<?> packet) {
        return new PacketWrapper(packet);
    }

    protected PacketUtil.ClientboundPacket wrap(int id, Packet<?> packet) {
        return new PacketWrapper(id, packet);
    }

    private final class PacketWrapper<T extends PacketListener>
    implements PacketUtil.ClientboundPacket {
        private final int id;
        private final Packet<T> packet;

        private PacketWrapper(int id, Packet<T> packet) {
            this.id = id;
            this.packet = packet;
        }

        private PacketWrapper(Packet<T> packet) {
            this(0, packet);
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public void send(Iterable<UUID> playerUUIDs) {
            for (UUID uuid : playerUUIDs) {
                ServerPlayer player = AbstractPacketUtil.this.playerList().getPlayer(uuid);
                if (player == null) continue;
                player.connection.send(this.packet);
            }
        }

        @Override
        public void broadcast(World world, Position center, int dist) {
            this.forEachPlayer(world, center, dist, p -> p.connection.send(this.packet));
        }

        private void forEachPlayer(World world, Position center, int dist, Consumer<ServerPlayer> playerConsumer) {
            int distanceSq = dist * dist;
            for (ServerPlayer player : AbstractPacketUtil.this.adapt(world).players()) {
                if (!(Vector3d.of(player.getX(), player.getY(), player.getZ()).distanceSq(center) <= (double)distanceSq)) continue;
                playerConsumer.accept(player);
            }
        }
    }
}

