/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.backup;

import io.leangen.geantyref.TypeToken;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.common.Bending;
import me.moros.bending.common.backup.ExportOperation;
import me.moros.bending.common.backup.ImportOperation;
import me.moros.bending.common.backup.Operation;
import me.moros.tasker.Task;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract sealed class AbstractOperation
implements Operation
permits ExportOperation, ImportOperation {
    protected static final String SUFFIX = ".json.gz";
    protected static final TypeToken<Map<String, BenderProfile[]>> PROFILES_TOKEN = new TypeToken<Map<String, BenderProfile[]>>(){};
    protected final Bending plugin;
    protected final BendingStorage storage;

    protected AbstractOperation(Bending plugin, BendingStorage storage) {
        this.plugin = plugin;
        this.storage = storage;
    }

    @Override
    public final CompletableFuture<Void> execute(AtomicBoolean lock) {
        long startTime = System.currentTimeMillis();
        return Tasker.async().submit(this::executeOperation).handle((result, t) -> {
            if (Boolean.TRUE.equals(result) && t == null) {
                this.onSuccess((double)(System.currentTimeMillis() - startTime) / 1000.0);
            } else {
                this.onFailure((Throwable)t);
            }
            lock.set(false);
            return null;
        });
    }

    protected abstract boolean executeOperation();

    protected abstract void onSuccess(double var1);

    protected abstract void onFailure(@Nullable Throwable var1);

    protected abstract void logProgress(int var1, int var2);

    protected final Task createProgressCheckingTask(LongAdder progress, int size) {
        return Tasker.async().repeat(() -> this.logProgress(progress.intValue(), size), 5L, TimeUnit.SECONDS);
    }
}

