/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.common.locale.Message;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;

public final class CommandUtil {
    private CommandUtil() {
    }

    public static String mapToSuggestion(AbilityDescription desc) {
        Key key = desc.key();
        return key.namespace().equals("bending") ? key.value() : key.asString();
    }

    public static List<Component> presetSlots(Preset preset) {
        ArrayList<Component> lines = new ArrayList<Component>();
        preset.forEach((desc, idx) -> lines.add(Component.text((String)(idx + 1 + ". "), (TextColor)ColorPalette.TEXT_COLOR).append(CommandUtil.mapToClickComponent(desc))));
        return lines;
    }

    public static Component presetDescription(Preset preset) {
        BuildableComponent details = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.join((JoinConfiguration)JoinConfiguration.newlines(), CommandUtil.presetSlots(preset)))).append((Component)Component.newline())).append((Component)Component.newline())).append(Message.HOVER_PRESET.build())).build();
        return preset.displayName().hoverEvent((HoverEventSource)HoverEvent.showText((Component)details)).clickEvent(ClickEvent.runCommand((String)("/bending preset bind " + preset.name())));
    }

    public static AbilityDisplay collectAll(Predicate<AbilityDescription> permissionChecker, Element element) {
        ElementSet singleElementSet = ElementSet.of(element);
        List<AbilityDisplay> all = List.of(CommandUtil.collectAbilities(permissionChecker, singleElementSet), CommandUtil.collectSequences(permissionChecker, singleElementSet), CommandUtil.collectPassives(permissionChecker, singleElementSet));
        return new AbilityDisplay(all);
    }

    private static AbilityDisplay collectAbilities(Predicate<AbilityDescription> permissionChecker, ElementSet singleElementSet) {
        List<Component> components = Registries.ABILITIES.stream().filter(desc -> !desc.hidden() && desc.canBind()).filter(desc -> singleElementSet.equals(desc.elements())).filter(permissionChecker).sorted(Comparator.comparing(Keyed::key)).map(CommandUtil::mapToClickComponent).toList();
        return new AbilityDisplay(Message.ABILITIES.build(), components);
    }

    private static AbilityDisplay collectSequences(Predicate<AbilityDescription> permissionChecker, ElementSet singleElementSet) {
        List<Component> components = Registries.SEQUENCES.stream().filter(desc -> !desc.hidden()).filter(desc -> singleElementSet.equals(desc.elements())).filter(permissionChecker).sorted(Comparator.comparing(Keyed::key)).map(CommandUtil::mapToClickComponent).toList();
        return new AbilityDisplay(Message.SEQUENCES.build(), components);
    }

    private static AbilityDisplay collectPassives(Predicate<AbilityDescription> permissionChecker, ElementSet singleElementSet) {
        List<Component> components = Registries.ABILITIES.stream().filter(desc -> !desc.hidden() && !desc.canBind()).filter(desc -> singleElementSet.equals(desc.elements()) && desc.isActivatedBy(Activation.PASSIVE)).filter(permissionChecker).sorted(Comparator.comparing(Keyed::key)).map(CommandUtil::mapToClickComponent).toList();
        return new AbilityDisplay(Message.PASSIVES.build(), components);
    }

    private static Component mapToClickComponent(AbilityDescription desc) {
        return desc.displayName().clickEvent(ClickEvent.runCommand((String)("/bending help " + desc.key().asString())));
    }

    public static final class AbilityDisplay
    implements Iterable<Component> {
        private final Collection<Component> display;

        private AbilityDisplay(Collection<AbilityDisplay> children) {
            this.display = children.stream().flatMap(AbilityDisplay::components).toList();
        }

        private AbilityDisplay(Component header, Collection<Component> abilities) {
            if (abilities.isEmpty()) {
                this.display = List.of();
            } else {
                JoinConfiguration sep = JoinConfiguration.commas((boolean)true);
                Component component = Component.join((JoinConfiguration)sep, abilities).colorIfAbsent(ColorPalette.TEXT_COLOR);
                this.display = List.of(header, component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Message.ABILITY_HOVER.build())));
            }
        }

        private Stream<Component> components() {
            return this.display.stream();
        }

        public boolean isEmpty() {
            return this.display.isEmpty();
        }

        @Override
        public Iterator<Component> iterator() {
            return this.display.iterator();
        }
    }
}

