/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.Command;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import bending.libraries.cloud.parser.standard.EnumParser;
import java.util.Locale;
import java.util.function.BiConsumer;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.element.ElementHandler;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.user.User;
import me.moros.bending.common.command.CommandUtil;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.command.parser.UserParser;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;

public record ElementCommand<C extends Audience>(Commander<C> commander) implements Initializer,
ElementHandler
{
    @Override
    public void init() {
        Command.Builder<C> builder = this.commander().rootBuilder();
        this.commander().register(builder.literal("choose", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.ELEMENT_CHOOSE_DESC.build())).permission(Permissions.CHOOSE).senderType(this.commander().playerType()).handler(c -> this.onElementChooseGUI(c.get(ContextKeys.BENDING_PLAYER))));
        this.commander().manager().command(builder.literal("choose", new String[0]).required("element", EnumParser.enumParser(Element.class)).commandDescription(RichDescription.of((ComponentLike)Message.ELEMENT_CHOOSE_DESC.build())).permission(Permissions.CHOOSE).senderType(this.commander().playerType()).handler(c -> this.onElementChoose(c.get(ContextKeys.BENDING_PLAYER), (Element)((Object)((Object)c.get("element"))))));
        this.commander().manager().command(builder.literal("choose", new String[0]).required("element", EnumParser.enumParser(Element.class)).required("target", UserParser.parser()).commandDescription(RichDescription.of((ComponentLike)Message.ELEMENT_CHOOSE_DESC.build())).permission(Permissions.CHOOSE + ".other").handler(c -> this.onElementSet((User)c.get("target"), (Element)((Object)((Object)c.get("element"))))));
        this.dualRegister(builder.literal("add", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.ELEMENT_ADD_DESC.build())).permission(Permissions.ADD), this::onElementAdd);
        this.dualRegister(builder.literal("remove", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.ELEMENT_REMOVE_DESC.build())).permission(Permissions.REMOVE), this::onElementRemove);
    }

    private void dualRegister(Command.Builder<C> builder, BiConsumer<User, Element> handler) {
        this.commander().manager().command(builder.required("element", EnumParser.enumParser(Element.class)).senderType(this.commander().playerType()).handler(c -> handler.accept(c.get(ContextKeys.BENDING_PLAYER), (Element)((Object)((Object)c.get("element"))))));
        this.commander().manager().command(builder.required("element", EnumParser.enumParser(Element.class)).required("target", UserParser.parser()).permission(builder.commandPermission().permissionString() + ".other").handler(c -> handler.accept((User)c.get("target"), (Element)((Object)((Object)c.get("element"))))));
    }

    private void onElementChooseGUI(User user) {
        Platform.instance().factory().buildMenu(this, user).ifPresent(g -> g.show((Player)((Object)user)));
    }

    @Override
    public void onElementChoose(User user, Element element) {
        if (!user.hasPermission(Permissions.CHOOSE + "." + element.toString().toLowerCase(Locale.ROOT))) {
            Message.ELEMENT_CHOOSE_NO_PERMISSION.send((Audience)user, element.displayName());
            return;
        }
        this.onElementSet(user, element);
    }

    private void onElementSet(User user, Element element) {
        if (user.chooseElement(element)) {
            Message.ELEMENT_CHOOSE_SUCCESS.send((Audience)user, element.displayName());
            this.sendElementNotification(user, element);
        } else {
            Message.ELEMENT_CHOOSE_FAIL.send((Audience)user, element.displayName());
        }
    }

    @Override
    public void onElementAdd(User user, Element element) {
        if (user.addElement(element)) {
            Message.ELEMENT_ADD_SUCCESS.send((Audience)user, element.displayName());
            this.sendElementNotification(user, element);
        } else {
            Message.ELEMENT_ADD_FAIL.send((Audience)user, element.displayName());
        }
    }

    @Override
    public void onElementRemove(User user, Element element) {
        if (user.removeElement(element)) {
            Message.ELEMENT_REMOVE_SUCCESS.send((Audience)user, element.displayName());
        } else {
            Message.ELEMENT_REMOVE_FAIL.send((Audience)user, element.displayName());
        }
    }

    @Override
    public void onElementDisplay(User user, Element element) {
        CommandUtil.AbilityDisplay display = CommandUtil.collectAll(user::hasPermission, element);
        if (display.isEmpty()) {
            Message.ELEMENT_ABILITIES_EMPTY.send((Audience)user, element.displayName());
        } else {
            Message.ELEMENT_ABILITIES_HEADER.send((Audience)user, element.displayName(), element.description());
            display.forEach(arg_0 -> ((User)user).sendMessage(arg_0));
        }
    }

    private void sendElementNotification(User user, Element element) {
        if (user instanceof Player) {
            Player player = (Player)((Object)user);
            player.sendNotification(Item.NETHER_STAR, Message.ELEMENT_TOAST_NOTIFICATION.build(element.displayName()));
        }
    }
}

