/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.Command;
import bending.libraries.cloud.CommandManager;
import bending.libraries.cloud.context.CommandContext;
import bending.libraries.cloud.minecraft.extras.ImmutableMinecraftHelp;
import bending.libraries.cloud.minecraft.extras.MinecraftHelp;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import bending.libraries.cloud.parser.standard.StringParser;
import bending.libraries.cloud.suggestion.BlockingSuggestionProvider;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.locale.Translation;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.common.command.CommandUtil;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.translation.GlobalTranslator;

public record HelpCommand<C extends Audience>(Commander<C> commander, MinecraftHelp<C> help) implements Initializer
{
    public HelpCommand(Commander<C> commander) {
        this(commander, HelpCommand.createHelp(commander.manager()));
    }

    @Override
    public void init() {
        Command.Builder<C> builder = this.commander().rootBuilder();
        this.commander().register(builder.commandDescription(RichDescription.of((ComponentLike)Message.BASE_DESC.build())).handler(c -> this.onHelp(c, "")));
        this.commander().register(builder.literal("help", new String[0]).optional("query", StringParser.greedyStringParser(), this.helpSuggestions()).commandDescription(RichDescription.of((ComponentLike)Message.HELP_DESC.build())).permission(Permissions.HELP).handler(c -> this.onHelp(c, c.getOrDefault("query", ""))));
    }

    private BlockingSuggestionProvider.Strings<C> helpSuggestions() {
        return (c, i) -> {
            Predicate<AbilityDescription> predicate = c.optional(ContextKeys.BENDING_PLAYER).map(this::permissionFilter).orElse(d -> true);
            return Stream.concat(Element.NAMES.stream(), Registries.ABILITIES.stream().filter(d -> !d.hidden()).filter(predicate).map(CommandUtil::mapToSuggestion)).toList();
        };
    }

    private Predicate<AbilityDescription> permissionFilter(User user) {
        return user::hasPermission;
    }

    private void onHelp(CommandContext<C> context, String rawQuery) {
        Audience sender = (Audience)context.sender();
        if (!rawQuery.isEmpty()) {
            Element element;
            int index = rawQuery.indexOf(32);
            String query = rawQuery.substring(0, index > 0 ? index : rawQuery.length());
            if (query.length() <= 5 && (element = Element.fromName(query)) != null) {
                this.onElementInfo(context, element);
                return;
            }
            AbilityDescription result = Registries.ABILITIES.fromString(query);
            if (result != null && !result.hidden() && this.permissionPredicate(context).test(result)) {
                this.onAbilityInfo(sender, result);
                return;
            }
        }
        this.help.queryCommands(rawQuery, sender);
    }

    private void onAbilityInfo(C sender, AbilityDescription ability) {
        Component instructions;
        Message.ABILITY_INFO_DESCRIPTION.send((Audience)sender, ability.displayName(), Message.ABILITY_DESCRIPTION.build(ability));
        if (ability instanceof AbilityDescription.Sequence) {
            AbilityDescription.Sequence sequence = (AbilityDescription.Sequence)ability;
            instructions = sequence.instructions();
        } else {
            String instructionsKey = ability.translationKey() + ".instructions";
            if (!GlobalTranslator.translator().canTranslate(instructionsKey, Translation.DEFAULT_LOCALE)) {
                return;
            }
            instructions = Message.ABILITY_INSTRUCTIONS.build(ability);
        }
        Message.ABILITY_INFO_INSTRUCTIONS.send((Audience)sender, ability.displayName(), instructions);
    }

    private void onElementInfo(CommandContext<C> context, Element element) {
        Audience user = (Audience)context.sender();
        CommandUtil.AbilityDisplay display = CommandUtil.collectAll(this.permissionPredicate(context), element);
        if (display.isEmpty()) {
            Message.ELEMENT_ABILITIES_EMPTY.send(user, element.displayName());
        } else {
            Message.ELEMENT_ABILITIES_HEADER.send(user, element.displayName(), element.description());
            display.forEach(arg_0 -> ((Audience)user).sendMessage(arg_0));
        }
    }

    private Predicate<AbilityDescription> permissionPredicate(CommandContext<C> context) {
        return desc -> desc.permissions().stream().allMatch(context::hasPermission);
    }

    private static <C extends Audience> MinecraftHelp<C> createHelp(CommandManager<C> manager) {
        return ImmutableMinecraftHelp.copyOf(MinecraftHelp.createNative("/bending help", manager)).withMaxResultsPerPage(9).withColors(MinecraftHelp.helpColors(ColorPalette.NEUTRAL, ColorPalette.TEXT_COLOR, ColorPalette.ACCENT, ColorPalette.HEADER, ColorPalette.NEUTRAL));
    }
}

