/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.Command;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import bending.libraries.cloud.parser.standard.StringParser;
import java.util.Set;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.ability.preset.PresetRegisterResult;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.common.command.CommandUtil;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.command.parser.PresetParser;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;

public record PresetCommand<C extends Audience>(Commander<C> commander) implements Initializer
{
    @Override
    public void init() {
        Command.Builder<C> builder = this.commander().rootBuilder().literal("preset", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.PRESET_DESC.build())).permission(Permissions.PRESET);
        this.commander().register(builder.literal("list", new String[0]).commandDescription(RichDescription.of((ComponentLike)Message.PRESET_LIST_DESC.build())).senderType(this.commander().playerType()).handler(c -> this.onPresetList(c.get(ContextKeys.BENDING_PLAYER))));
        this.commander().register(builder.literal("create", new String[0]).required("name", StringParser.stringParser()).commandDescription(RichDescription.of((ComponentLike)Message.PRESET_CREATE_DESC.build())).senderType(this.commander().playerType()).handler(c -> this.onPresetCreate(c.get(ContextKeys.BENDING_PLAYER), (String)c.get("name"))));
        this.commander().register(builder.literal("remove", new String[0]).required("preset", PresetParser.parser()).commandDescription(RichDescription.of((ComponentLike)Message.PRESET_REMOVE_DESC.build())).senderType(this.commander().playerType()).handler(c -> this.onPresetRemove(c.get(ContextKeys.BENDING_PLAYER), (Preset)c.get("preset"))));
        this.commander().register(builder.literal("bind", new String[0]).required("preset", PresetParser.parser()).commandDescription(RichDescription.of((ComponentLike)Message.PRESET_BIND_DESC.build())).senderType(this.commander().playerType()).handler(c -> this.onPresetBind(c.get(ContextKeys.BENDING_PLAYER), (Preset)c.get("preset"))));
    }

    private void onPresetList(User user) {
        Set presets = user.presets();
        if (presets.isEmpty()) {
            Message.NO_PRESETS.send((Audience)user);
        } else {
            Message.PRESET_LIST_HEADER.send((Audience)user, user.presetSize());
            JoinConfiguration sep = JoinConfiguration.commas((boolean)true);
            Component presetList = Component.join((JoinConfiguration)sep, presets.stream().map(CommandUtil::presetDescription).toList());
            user.sendMessage(presetList.colorIfAbsent(ColorPalette.TEXT_COLOR));
        }
    }

    private void onPresetCreate(User user, String name) {
        String input = TextUtil.sanitizeInput(name);
        if (input.isEmpty()) {
            Message.INVALID_PRESET_NAME.send((Audience)user);
            return;
        }
        Preset preset = user.slots();
        if (preset.isEmpty()) {
            Message.EMPTY_PRESET.send((Audience)user);
            return;
        }
        PresetRegisterResult result = user.addPreset(preset.withName(input));
        user.sendMessage(this.mapPresetResult(result, input));
    }

    private Component mapPresetResult(PresetRegisterResult result, String name) {
        Message.Args1<String> msg = switch (result) {
            default -> throw new MatchException(null, null);
            case PresetRegisterResult.SUCCESS -> Message.PRESET_SUCCESS;
            case PresetRegisterResult.EXISTS -> Message.PRESET_EXISTS;
            case PresetRegisterResult.CANCELLED -> Message.PRESET_CANCELLED;
            case PresetRegisterResult.FAIL -> Message.PRESET_FAIL;
        };
        return msg.build(name);
    }

    private void onPresetRemove(User user, Preset preset) {
        if (user.removePreset(preset)) {
            Message.PRESET_REMOVE_SUCCESS.send((Audience)user, preset.name());
        } else {
            Message.PRESET_REMOVE_FAIL.send((Audience)user, preset.name());
        }
    }

    private void onPresetBind(User user, Preset preset) {
        if (user.bindPreset(preset)) {
            Message.PRESET_BIND_SUCCESS.send((Audience)user, preset.name());
        } else {
            Message.PRESET_BIND_FAIL.send((Audience)user, preset.name());
        }
    }
}

