/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.config;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.config.ConfigProcessor;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.AttributeModifier;
import me.moros.bending.api.config.attribute.AttributeValue;
import me.moros.bending.api.config.attribute.Modifier;
import me.moros.bending.api.user.AttributeUser;
import me.moros.bending.common.config.processor.CachedConfig;
import me.moros.bending.common.logging.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.reference.ConfigurationReference;

record ConfigProcessorImpl(Logger logger, ConfigurationReference<? extends ConfigurationNode> root, Map<Class<? extends Configurable>, CachedConfig<?>> cache) implements ConfigProcessor
{
    ConfigProcessorImpl(Logger logger, ConfigurationReference<? extends ConfigurationNode> root) {
        this(logger, root, new ConcurrentHashMap());
    }

    void cache(Class<? extends Configurable> configType) {
        this.getCachedConfig(configType);
    }

    @Override
    public <T extends Configurable> T calculate(AttributeUser user, AbilityDescription desc, Class<T> configType) {
        return this.getCachedConfig(configType).withAttributes(this.collectActiveModifiers(user, desc), t -> this.logger.warn(t.getMessage(), (Throwable)t));
    }

    @Override
    public Collection<AttributeValue> listAttributes(AttributeUser user, AbilityDescription desc, Class<? extends Configurable> configType) {
        return this.getCachedConfig(configType).readAttributes(this.collectActiveModifiers(user, desc));
    }

    private Map<Attribute, Modifier> collectActiveModifiers(AttributeUser user, AbilityDescription desc) {
        return user.attributeModifiers().stream().filter(modifier -> modifier.policy().shouldModify(desc)).collect(Collectors.toMap(AttributeModifier::attribute, AttributeModifier::modifier, Modifier::merge));
    }

    private <T extends Configurable> CachedConfig<T> getCachedConfig(Class<T> configType) {
        return this.cache.computeIfAbsent(configType, s -> {
            try {
                return CachedConfig.createFrom(this.root, configType);
            }
            catch (CachedConfig.ConfigException e) {
                this.logger.warn(e.getMessage(), e);
                return null;
            }
        });
    }
}

