/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.game.FlightManager;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.user.User;
import net.kyori.adventure.util.TriState;

public final class FlightManagerImpl
implements FlightManager {
    private final Map<UUID, FlightImpl> instances = new HashMap<UUID, FlightImpl>();

    FlightManagerImpl() {
    }

    @Override
    public boolean hasFlight(User user) {
        return this.instances.containsKey(user.uuid());
    }

    @Override
    public FlightManager.Flight get(User user) {
        FlightImpl flight = this.instances.computeIfAbsent(user.uuid(), u -> new FlightImpl(this, user));
        ++flight.references;
        return flight;
    }

    @Override
    public void remove(UUID uuid) {
        FlightImpl instance = this.instances.remove(uuid);
        if (instance != null) {
            instance.revert();
        }
    }

    @Override
    public void removeAll() {
        this.instances.values().forEach(FlightImpl::revert);
        this.instances.clear();
    }

    @Override
    public Updatable.UpdateResult update() {
        this.instances.values().forEach(FlightImpl::update);
        return Updatable.UpdateResult.CONTINUE;
    }

    public static final class FlightImpl
    implements FlightManager.Flight {
        private final FlightManager manager;
        private final User user;
        private final TriState couldFly;
        private final TriState wasFlying;
        private TriState isFlying;
        private int references = 0;

        private FlightImpl(FlightManager manager, User user) {
            this.manager = manager;
            this.user = user;
            this.couldFly = user.checkProperty(EntityProperties.ALLOW_FLIGHT);
            this.wasFlying = user.checkProperty(EntityProperties.FLYING);
            this.isFlying = TriState.NOT_SET;
        }

        @Override
        public User user() {
            return this.user;
        }

        @Override
        public void flying(boolean value) {
            this.isFlying = TriState.byBoolean((boolean)value);
            this.user.setProperty(EntityProperties.ALLOW_FLIGHT, value);
            this.user.setProperty(EntityProperties.FLYING, value);
        }

        @Override
        public void release() {
            if (--this.references < 1) {
                this.manager.remove(this.user.uuid());
            }
        }

        private void revert() {
            this.user.setProperty(EntityProperties.ALLOW_FLIGHT, this.couldFly);
            this.user.setProperty(EntityProperties.FLYING, this.wasFlying);
        }

        private void update() {
            if (this.user.checkProperty(EntityProperties.FLYING) != this.isFlying) {
                this.user.setProperty(EntityProperties.FLYING, this.isFlying);
            }
        }
    }
}

