/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.game.AbilityManager;
import me.moros.bending.api.game.WorldManager;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.common.config.ConfigManager;
import me.moros.bending.common.game.AbilityManagerImpl;
import me.moros.bending.common.game.CollisionManager;
import me.moros.bending.common.game.DummyAbilityManager;
import me.moros.bending.common.logging.Logger;
import net.kyori.adventure.key.Key;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public final class WorldManagerImpl
implements WorldManager {
    private final Logger logger;
    private final Map<Key, ManagerPair> worlds;
    private final Set<Key> disabled;

    WorldManagerImpl(Logger logger) {
        this.logger = logger;
        this.worlds = new ConcurrentHashMap<Key, ManagerPair>();
        this.disabled = ConcurrentHashMap.newKeySet();
        this.refreshDisabled();
    }

    private void refreshDisabled() {
        this.disabled.clear();
        for (String raw : ConfigManager.load((Supplier<Config>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lme/moros/bending/common/game/WorldManagerImpl$Config;)()).disabledWorlds) {
            Key key = KeyUtil.VANILLA_KEY_MAPPER.apply(raw.toLowerCase(Locale.ROOT));
            if (key == null) continue;
            this.disabled.add(key);
        }
    }

    @Override
    public AbilityManager instance(Key world) {
        return this.isEnabled(world) ? this.computePair((Key)world).abilities : DummyAbilityManager.INSTANCE;
    }

    private ManagerPair computePair(Key world) {
        return this.worlds.computeIfAbsent(world, this::createPair);
    }

    private ManagerPair createPair(Key world) {
        AbilityManagerImpl abilities = new AbilityManagerImpl(this.logger, world);
        return new ManagerPair(abilities, new CollisionManager(abilities));
    }

    @Override
    public Updatable.UpdateResult update() {
        this.worlds.values().forEach(ManagerPair::update);
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public boolean isEnabled(Key world) {
        return !this.disabled.contains(world);
    }

    @Override
    public void forEach(Consumer<AbilityManager> consumer) {
        for (ManagerPair pair : this.worlds.values()) {
            consumer.accept(pair.abilities);
        }
    }

    @Override
    public void onWorldUnload(Key world) {
        ManagerPair pair = this.worlds.remove(world);
        if (pair != null) {
            pair.abilities.destroyAllInstances();
        }
    }

    @Override
    public void onUserChangeWorld(UUID uuid, Key oldWorld, Key newWorld) {
        User user;
        if (this.isEnabled(newWorld) && (user = (User)Registries.BENDERS.get(uuid)) != null) {
            user.board().updateAll();
            this.instance(oldWorld).destroyUserInstances(user);
            this.instance(newWorld).createPassives(user);
        }
    }

    private static final class Config
    implements Configurable {
        @Comment(value="Worlds are specified by their key, e.g. minecraft:overworld")
        private List<String> disabledWorlds = List.of("disabledbendingworld");

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("properties");
        }
    }

    private record ManagerPair(AbilityManager abilities, CollisionManager collisions) {
        private void update() {
            this.abilities.update();
            this.collisions.update();
        }
    }
}

