/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.hook;

import java.util.function.ToIntFunction;
import me.moros.bending.api.addon.Addon;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.event.PresetRegisterEvent;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.user.User;
import me.moros.bending.common.locale.Message;
import net.kyori.adventure.audience.Audience;

public record PresetLimits(ToIntFunction<User> maxPresetsFn) implements Addon
{
    public static final String NAME = "preset-limits";
    private static final Addon DEFAULT_LIMITS = new PresetLimits(u -> BendingProperties.instance().maxPresets());

    private void onPresetRegister(PresetRegisterEvent event) {
        int maxPresets = this.maxPresetsFn.applyAsInt(event.user());
        if (maxPresets > 0 && event.user().presetSize() >= maxPresets) {
            Message.PRESET_LIMIT.send((Audience)event.user(), maxPresets);
            event.cancelled(true);
        }
    }

    @Override
    public void enable(Game game) {
        game.eventBus().subscribe(PresetRegisterEvent.class, this::onPresetRegister);
    }

    public static Addon defaultLimits() {
        return DEFAULT_LIMITS;
    }
}

