/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.common.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

abstract class AbstractStorage
implements BendingStorage {
    protected final Logger logger;
    private final Executor executor;

    protected AbstractStorage(Logger logger) {
        this.logger = logger;
        this.executor = Tasker.async();
    }

    private <R> CompletableFuture<R> async(Supplier<R> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.executor);
    }

    private CompletableFuture<Void> async(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.executor);
    }

    @Override
    public final CompletableFuture<Set<UUID>> loadUuidsAsync() {
        return this.async(this::loadUuids).exceptionally(this.logError(Set.of()));
    }

    @Override
    public final CompletableFuture<@Nullable BenderProfile> loadProfileAsync(UUID uuid) {
        return this.async(() -> this.loadProfile(uuid)).exceptionally(this.logError(null));
    }

    @Override
    public final Map<UUID, BenderProfile> loadProfiles(Set<UUID> uuids) {
        HashMap<UUID, BenderProfile> results = new HashMap<UUID, BenderProfile>(uuids.size());
        for (UUID uuid : uuids) {
            results.computeIfAbsent(uuid, this::loadProfile);
        }
        return results;
    }

    @Override
    public final CompletableFuture<Map<UUID, BenderProfile>> loadProfilesAsync(Set<UUID> uuids, LongAdder progressCounter) {
        int size = uuids.size();
        ConcurrentHashMap results = new ConcurrentHashMap(size);
        CompletableFuture[] futures = new CompletableFuture[size];
        AtomicInteger counter = new AtomicInteger();
        for (UUID uuid : uuids) {
            futures[counter.getAndIncrement()] = this.async(() -> {
                results.computeIfAbsent(uuid, this::loadProfile);
                progressCounter.increment();
            });
        }
        return CompletableFuture.allOf(futures).handle((ignore, t) -> {
            if (t != null) {
                this.logger.warn(t.getMessage(), (Throwable)t);
            }
            return results;
        });
    }

    @Override
    public final CompletableFuture<Boolean> saveProfileAsync(BenderProfile profile) {
        return this.async(() -> this.saveProfile(profile)).exceptionally((Function)this.logError(false));
    }

    @Override
    public final boolean saveProfiles(Collection<BenderProfile> profiles) {
        boolean result = false;
        for (BenderProfile profile : profiles) {
            result |= this.saveProfile(profile);
        }
        return result;
    }

    @Override
    public final CompletableFuture<Boolean> saveProfilesAsync(Collection<BenderProfile> profiles, LongAdder progressCounter) {
        int size = profiles.size();
        CompletableFuture[] futures = new CompletableFuture[size];
        AtomicInteger counter = new AtomicInteger();
        LongAdder successful = new LongAdder();
        for (BenderProfile profile : profiles) {
            futures[counter.getAndIncrement()] = this.async(() -> {
                if (this.saveProfile(profile)) {
                    successful.increment();
                }
                progressCounter.increment();
            });
        }
        if (futures.length == 0) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.allOf(futures).handle((ignore, t) -> {
            if (t != null) {
                this.logger.warn(t.getMessage(), (Throwable)t);
            }
            return successful.intValue() == size;
        });
    }

    private <R> Function<Throwable, @PolyNull R> logError(@PolyNull R def) {
        return t -> {
            this.logger.error(t.getMessage(), (Throwable)t);
            return def;
        };
    }
}

