/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.storage.AbstractStorage;
import me.moros.bending.common.storage.file.IOFunction;
import me.moros.bending.common.storage.file.loader.Loader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.reference.ConfigurationReference;

final class FileStorage
extends AbstractStorage {
    private static final String SUFFIX = ".json";
    private final Path dataPath;
    private final Loader<?> loader;
    private final LoadingCache<Path, ReentrantLock> locks;
    private final Semaphore semaphore;

    FileStorage(Logger logger, Path directory, Loader<?> loader) {
        super(logger);
        this.dataPath = directory;
        this.loader = loader;
        try {
            Files.createDirectories(this.dataPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.locks = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(key -> new ReentrantLock());
        this.semaphore = new Semaphore(Math.max(Runtime.getRuntime().availableProcessors(), 2));
    }

    private Path filePath(UUID uuid) {
        return this.dataPath.resolve(String.valueOf(uuid) + SUFFIX);
    }

    @Override
    public Set<UUID> loadUuids() {
        Set<UUID> set;
        block8: {
            Stream<Path> stream = Files.list(this.dataPath);
            try {
                set = stream.map(p -> p.getFileName().toString()).filter(name -> name.endsWith(SUFFIX)).map(name -> name.substring(0, name.length() - SUFFIX.length())).map(TextUtil::parseUUID).filter(Objects::nonNull).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return set;
    }

    @Override
    public @Nullable BenderProfile loadProfile(UUID uuid) {
        Path path = this.filePath(uuid);
        return this.loadDataFile(path, ref -> Files.exists(path, new LinkOption[0]) ? (BenderProfile)ref.node().get(BenderProfile.class) : null, null);
    }

    @Override
    public boolean saveProfile(BenderProfile profile) {
        return this.loadDataFile(this.filePath(profile.uuid()), ref -> {
            ref.set(NodePath.path(), (Object)profile);
            ref.save();
            return true;
        }, false);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R loadDataFile(Path path, IOFunction<ConfigurationReference<?>, R> function, R onException) {
        ReentrantLock lock = (ReentrantLock)this.locks.get((Object)path);
        lock.lock();
        this.semaphore.acquireUninterruptibly();
        try {
            R r;
            block11: {
                ConfigurationReference<ConfigurationNode> ref = this.loader.load(path);
                try {
                    r = function.apply(ref);
                    if (ref == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ref != null) {
                            try {
                                ref.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.warn(e.getMessage(), e);
                        R r2 = onException;
                        return r2;
                    }
                }
                ref.close();
            }
            return r;
        }
        finally {
            this.semaphore.release();
            lock.unlock();
        }
    }

    public String toString() {
        return "Json";
    }

    @Override
    public void close() {
    }
}

