/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage;

import bending.libraries.storage.StorageType;
import java.util.Optional;
import me.moros.bending.common.storage.file.loader.JsonLoader;
import me.moros.bending.common.storage.file.loader.Loader;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum StorageEngine {
    MYSQL(StorageType.MYSQL),
    MARIADB(StorageType.MARIADB),
    POSTGRESQL(StorageType.POSTGRESQL),
    H2(StorageType.H2),
    HSQL(StorageType.HSQL),
    JSON("JSON", new JsonLoader());

    private final String name;
    private final StorageType type;
    private final Loader<?> loader;

    private StorageEngine(StorageType type) {
        this(type.toString(), type, null);
    }

    private StorageEngine(String name, Loader<?> loaderSupplier) {
        this(name, null, loaderSupplier);
    }

    private StorageEngine(@Nullable String name, StorageType type, Loader<?> loader) {
        this.name = name;
        this.type = type;
        this.loader = loader;
    }

    public String toString() {
        return this.name;
    }

    public Optional<StorageType> type() {
        return Optional.ofNullable(this.type);
    }

    public Optional<Loader<?>> loader() {
        return Optional.ofNullable(this.loader);
    }
}

