/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage.sql.migration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;

public class V1__Rename_legacy_tables
extends BaseJavaMigration {
    private static final String RENAME_TABLE = "ALTER TABLE %s RENAME TO %s;";

    public void migrate(Context context) throws Exception {
        Connection conn = context.getConnection();
        Set<String> tables = this.fetchTables(conn);
        ArrayList queries = new ArrayList();
        this.renameTable(tables, "bending_abilities").ifPresent(queries::add);
        this.renameTable(tables, "bending_presets").ifPresent(queries::add);
        if (!queries.isEmpty()) {
            try (Statement statement = conn.createStatement();){
                for (String query : queries) {
                    statement.addBatch(query);
                }
                statement.executeBatch();
            }
        }
    }

    private Optional<String> renameTable(Set<String> tables, String table) {
        return tables.contains(table) ? Optional.of(RENAME_TABLE.formatted(table, table + "_old")) : Optional.empty();
    }

    private Set<String> fetchTables(Connection connection) throws Exception {
        HashSet<String> tables = new HashSet<String>();
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), null, "%", null);){
            while (rs.next()) {
                String tableName = rs.getString(3).toLowerCase(Locale.ROOT);
                if (!tableName.startsWith("bending")) continue;
                tables.add(tableName);
            }
        }
        return tables;
    }
}

