/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> @Nullable Class<T> findInnerClass(Object parent, Class<T> clazz) {
        for (Class<?> innerClass : parent.getClass().getDeclaredClasses()) {
            if (!clazz.isAssignableFrom(innerClass)) continue;
            return innerClass;
        }
        return null;
    }

    public static <T> @Nullable T tryCreateInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getClassOrThrow(String fullName) {
        try {
            return Class.forName(fullName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> void injectStatic(Class<?> clazz, V value) {
        Class<?> valueClass = value.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (ReflectionUtil.isFinal(field) || !field.getType().isAssignableFrom(valueClass)) continue;
            ReflectionUtil.accessField(field, f -> {
                f.set(null, value);
                return f;
            });
            return;
        }
    }

    public static <V> V getStaticFieldOrThrow(Class<?> clazz, String fieldName) {
        return ReflectionUtil.getFieldAs(clazz, fieldName, null);
    }

    private static <T, V> V getFieldAs(Class<?> clazz, String fieldName, @Nullable T instance) {
        try {
            Field field = ReflectionUtil.getFieldSafe(clazz, fieldName);
            return (V)ReflectionUtil.accessField(field, f -> f.get(instance)).orElseThrow();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getFieldSafe(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        return clazz.getDeclaredField(fieldName);
    }

    private static <R> Optional<R> accessField(Field field, FieldFunction<R> function) {
        field.setAccessible(true);
        try {
            return Optional.of(function.apply(field));
        }
        catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) == 16;
    }

    @FunctionalInterface
    private static interface FieldFunction<R> {
        public R apply(Field var1) throws IllegalAccessException;
    }
}

