/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.util.stamina;

import java.util.Objects;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.common.util.stamina.StaminaGauge;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;

public final class StaminaBar
implements Updatable {
    private static final int INTERVAL_FACTOR = 20;
    private static final int REGEN_DELAY = 30;
    private final BossBar bar;
    private final Audience audience;
    private final StaminaGauge gauge;
    private final int staminaRegen;
    private State state = State.IDLE;
    private int ticksUntilRegen = 30;
    private boolean visible = false;

    StaminaBar(Builder builder, Audience audience) {
        this.bar = builder.bar;
        this.audience = audience;
        this.gauge = new StaminaGauge(20 * builder.maxStamina, 20 * builder.stamina);
        this.staminaRegen = builder.staminaRegen;
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.gauge.isEmpty()) {
            this.reset();
            return Updatable.UpdateResult.REMOVE;
        }
        this.handleState();
        return Updatable.UpdateResult.CONTINUE;
    }

    private void handleState() {
        if (this.state == State.PRE_REGENERATING) {
            if (--this.ticksUntilRegen <= 0) {
                this.resetTicksForRegen();
                this.state = State.REGENERATING;
            }
        } else if (this.state == State.REGENERATING && !this.gauge.increment(this.staminaRegen)) {
            this.hide();
        }
        if (this.state != State.IDLE) {
            this.bar.progress(this.gauge.progress());
        }
        if (!this.gauge.isFull()) {
            this.show();
        }
    }

    private void show() {
        if (!this.visible) {
            this.audience.showBossBar(this.bar);
            this.visible = true;
        }
    }

    private void hide() {
        if (this.visible) {
            this.audience.hideBossBar(this.bar);
            this.visible = false;
        }
    }

    public boolean hasAtLeast(int amount) {
        return this.gauge.hasAtLeast(20 * amount);
    }

    public boolean fill(int amount) {
        return this.gauge.increment(20 * amount);
    }

    public boolean drainCost(int amount) {
        this.state = State.DRAINING;
        return this.gauge.decrement(20 * amount);
    }

    public boolean tickingDrain(int amount) {
        this.state = State.DRAINING;
        return this.gauge.decrement(amount);
    }

    public void reset() {
        this.hide();
        if (this.state == State.DRAINING) {
            this.state = State.PRE_REGENERATING;
            this.resetTicksForRegen();
        }
    }

    private void resetTicksForRegen() {
        this.ticksUntilRegen = 30;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum State {
        IDLE,
        DRAINING,
        PRE_REGENERATING,
        REGENERATING;

    }

    public static final class Builder {
        private BossBar bar;
        private int maxStamina = 200;
        private int stamina = 0;
        private int staminaRegen = 25;

        public Builder bar(BossBar bar) {
            this.bar = bar;
            return this;
        }

        public Builder maxStamina(int maxStamina) {
            this.maxStamina = Math.max(1, maxStamina);
            return this;
        }

        public Builder stamina(int stamina) {
            this.stamina = stamina;
            return this;
        }

        public Builder staminaRegen(int staminaRegen) {
            this.staminaRegen = staminaRegen;
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.bar);
            if (this.stamina <= 0 || this.stamina > this.maxStamina) {
                this.stamina = this.maxStamina;
            }
        }

        public StaminaBar build(Audience audience) {
            Objects.requireNonNull(audience);
            this.validate();
            return new StaminaBar(this, audience);
        }
    }
}

