/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.util.stamina;

final class StaminaGauge {
    private final int max;
    private int stamina;

    StaminaGauge(int max, int stamina) {
        this.max = max;
        this.stamina = Math.clamp((long)stamina, 0, max);
    }

    public float progress() {
        return Math.clamp((float)this.stamina / (float)this.max, 0.0f, 1.0f);
    }

    public boolean hasAtLeast(int amount) {
        return this.stamina >= amount;
    }

    public boolean decrement(int amount) {
        if (amount > 0 && this.stamina >= amount) {
            this.stamina -= amount;
            return true;
        }
        return false;
    }

    public boolean increment(int amount) {
        if (amount > 0 && this.stamina < this.max) {
            this.stamina = Math.min(this.stamina + amount, this.max);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stamina <= 0;
    }

    public boolean isFull() {
        return this.stamina >= this.max;
    }
}

