/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper;

import bending.libraries.bstats.bukkit.Metrics;
import bending.libraries.bstats.charts.AdvancedPie;
import bending.libraries.bstats.charts.SimplePie;
import bending.libraries.bstats.charts.SingleLineChart;
import bending.libraries.cloud.execution.ExecutionCoordinator;
import bending.libraries.cloud.paper.LegacyPaperCommandManager;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.ElementUser;
import me.moros.bending.common.AbstractBending;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.hook.LuckPermsHook;
import me.moros.bending.common.hook.MiniPlaceholdersHook;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.util.ReflectionUtil;
import me.moros.bending.paper.BendingBootstrap;
import me.moros.bending.paper.hook.PlaceholderAPIHook;
import me.moros.bending.paper.listener.BlockListener;
import me.moros.bending.paper.listener.ConnectionListener;
import me.moros.bending.paper.listener.UserListener;
import me.moros.bending.paper.listener.WorldListener;
import me.moros.bending.paper.platform.BrigadierSetup;
import me.moros.bending.paper.platform.BukkitPermissionInitializer;
import me.moros.bending.paper.platform.BukkitPlatform;
import me.moros.bending.paper.protection.ProtectionInitializer;
import me.moros.tasker.paper.PaperExecutor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;

final class PaperBending
extends AbstractBending<BendingBootstrap> {
    PaperBending(BendingBootstrap parent, Path dir, Logger logger) {
        super(parent, dir, logger);
    }

    void onPluginEnable() {
        this.injectTasker(new PaperExecutor((Plugin)this.parent));
        String version = ((BendingBootstrap)((Object)this.parent)).getPluginMeta().getAPIVersion();
        ReflectionUtil.injectStatic(Platform.Holder.class, new BukkitPlatform(this.logger(), version));
        new ProtectionInitializer().init();
        this.registerHooks(((BendingBootstrap)((Object)this.parent)).getServer());
        this.load();
        new BukkitPermissionInitializer().init();
        PluginManager pluginManager = ((BendingBootstrap)((Object)this.parent)).getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new BlockListener(this.game), (Plugin)this.parent);
        pluginManager.registerEvents((Listener)new UserListener(this.game), (Plugin)this.parent);
        pluginManager.registerEvents((Listener)new ConnectionListener(this.logger(), this.game), (Plugin)this.parent);
        pluginManager.registerEvents((Listener)new WorldListener(this.game), (Plugin)this.parent);
        LegacyPaperCommandManager<CommandSender> manager = LegacyPaperCommandManager.createNative((Plugin)this.parent, ExecutionCoordinator.simpleCoordinator());
        manager.registerBrigadier();
        BrigadierSetup.setup(manager);
        Commander.create(manager, Player.class, this).init();
        ((BendingBootstrap)((Object)this.parent)).getServer().getServicesManager().register(Game.class, (Object)this.game, (Plugin)this.parent, ServicePriority.Normal);
    }

    void onPluginDisable() {
        this.disable();
    }

    private void registerHooks(Server server) {
        if (server.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPIHook(this).register();
        }
        if (server.getPluginManager().isPluginEnabled("MiniPlaceholders")) {
            new MiniPlaceholdersHook().init();
        }
        if (server.getPluginManager().isPluginEnabled("LuckPerms")) {
            LuckPermsHook<Player> hook = LuckPermsHook.register(OfflinePlayer::getUniqueId);
            this.registerNamedAddon("preset-limits", hook::presetLimits);
        }
        this.setupCustomCharts(new Metrics((Plugin)this.parent, 8717));
    }

    private void setupCustomCharts(Metrics metrics) {
        metrics.addCustomChart(new SimplePie("storage_engine", () -> this.game.storage().toString().toLowerCase(Locale.ROOT)));
        metrics.addCustomChart(new AdvancedPie("protections", () -> Registries.PROTECTIONS.stream().collect(Collectors.groupingBy(p -> p.key().value(), Collectors.summingInt(e -> 1)))));
        metrics.addCustomChart(new AdvancedPie("player_elements", () -> Registries.BENDERS.players().map(ElementUser::elements).flatMap(Collection::stream).collect(Collectors.groupingBy(Element::toString, Collectors.summingInt(e -> 1)))));
        metrics.addCustomChart(new SingleLineChart("bending_npc_count", Registries.BENDERS::nonPlayerCount));
    }

    @Override
    public String author() {
        return (String)((BendingBootstrap)((Object)this.parent)).getPluginMeta().getAuthors().getFirst();
    }

    @Override
    public String version() {
        return ((BendingBootstrap)((Object)this.parent)).getPluginMeta().getVersion();
    }
}

