/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.listener;

import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.paper.listener.BukkitListener;
import me.moros.bending.paper.platform.PlatformAdapter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;

public record BlockListener(Game game) implements Listener,
BukkitListener
{
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Block block;
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        org.bukkit.block.Block b = event.getIgnitingBlock();
        Block block2 = block = b == null ? null : PlatformAdapter.fromBukkitBlock(b);
        if (TempBlock.MANAGER.isTemp(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        if (TempBlock.MANAGER.isTemp(PlatformAdapter.fromBukkitBlock(event.getSource()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        Block block = PlatformAdapter.fromBukkitBlock(event.getBlock());
        if (!MaterialUtil.isFire(block) && TempBlock.MANAGER.isTemp(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block;
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        org.bukkit.block.Block b = event.getIgnitingBlock();
        Block block2 = block = b == null ? null : PlatformAdapter.fromBukkitBlock(b);
        if (TempBlock.MANAGER.isTemp(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        if (ActionLimiter.isLimited(event.getPlayer().getUniqueId(), ActionType.INTERACT_BLOCK)) {
            event.setCancelled(true);
            return;
        }
        TempBlock.MANAGER.get(PlatformAdapter.fromBukkitBlock(event.getBlock())).ifPresent(TempBlock::removeWithoutReverting);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = PlatformAdapter.fromBukkitBlock(event.getBlock());
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        TempBlock tb = TempBlock.MANAGER.get(block).orElse(null);
        if (tb != null) {
            event.setDropItems(false);
            tb.removeWithoutReverting();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        if (TempBlock.MANAGER.isTemp(PlatformAdapter.fromBukkitBlock(event.getBlock()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        if (TempBlock.MANAGER.isTemp(PlatformAdapter.fromBukkitBlock(event.getBlock())) || TempBlock.MANAGER.isTemp(PlatformAdapter.fromBukkitBlock(event.getToBlock()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        org.bukkit.block.Block block = event.getBlock();
        if (block.getType().hasGravity() && TempBlock.shouldIgnorePhysics(PlatformAdapter.fromBukkitBlock(block))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPistonExtendEvent(BlockPistonExtendEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        if (event.getBlocks().stream().map(PlatformAdapter::fromBukkitBlock).anyMatch(TempBlock.MANAGER::isTemp)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPistonRetractEvent(BlockPistonRetractEvent event) {
        if (this.disabledWorld((BlockEvent)event)) {
            return;
        }
        if (event.getBlocks().stream().map(PlatformAdapter::fromBukkitBlock).anyMatch(TempBlock.MANAGER::isTemp)) {
            event.setCancelled(true);
        }
    }
}

