/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.listener;

import me.moros.bending.api.game.Game;
import me.moros.bending.common.listener.AbstractConnectionListener;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.paper.platform.entity.BukkitPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public final class ConnectionListener
extends AbstractConnectionListener
implements Listener {
    public ConnectionListener(Logger logger, Game game) {
        super(logger, game);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        this.asyncJoin(event.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.syncJoin(player.getUniqueId(), () -> new BukkitPlayer(player));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogout(PlayerQuitEvent event) {
        this.onQuit(event.getPlayer().getUniqueId());
    }
}

