/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform;

import com.destroystokyo.paper.MaterialTags;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.moros.bending.api.ability.element.ElementHandler;
import me.moros.bending.api.adapter.NativeAdapter;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.gui.ElementGui;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.PlatformFactory;
import me.moros.bending.api.platform.PlatformType;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemBuilder;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.user.User;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.paper.adapter.AdapterLoader;
import me.moros.bending.paper.gui.BoardImpl;
import me.moros.bending.paper.gui.ElementMenu;
import me.moros.bending.paper.platform.BukkitRegistryInitializer;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.item.BukkitItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ItemStack;

public class BukkitPlatform
implements Platform,
PlatformFactory {
    private final NativeAdapter adapter;
    private final boolean hasNativeSupport;
    private final LoadingCache<Item, ItemSnapshot> campfireRecipesCache;

    public BukkitPlatform(Logger logger, String version) {
        new BukkitRegistryInitializer().init();
        this.adapter = AdapterLoader.loadAdapter(logger, version);
        this.hasNativeSupport = this.adapter != AdapterLoader.DUMMY;
        this.campfireRecipesCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(this::findCampfireRecipe);
    }

    @Override
    public PlatformFactory factory() {
        return this;
    }

    @Override
    public PlatformType type() {
        return PlatformType.BUKKIT;
    }

    @Override
    public boolean hasNativeSupport() {
        return this.hasNativeSupport;
    }

    @Override
    public NativeAdapter nativeAdapter() {
        return this.adapter;
    }

    @Override
    public Optional<Board> buildBoard(User user) {
        if (this.hasNativeSupport() && user instanceof Player) {
            return Optional.of(new BoardImpl(user));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ElementGui> buildMenu(ElementHandler handler, User user) {
        if (user instanceof Player) {
            Player player = (Player)((Object)user);
            return Optional.of(ElementMenu.createMenu(handler, player));
        }
        return Optional.empty();
    }

    @Override
    public ItemBuilder itemBuilder(Item item) {
        return new BukkitItemBuilder(PlatformAdapter.toBukkitItem(item));
    }

    @Override
    public ItemBuilder itemBuilder(ItemSnapshot snapshot) {
        return new BukkitItemBuilder(PlatformAdapter.toBukkitItem(snapshot));
    }

    @Override
    public Optional<ItemSnapshot> campfireRecipeCooked(Item input) {
        ItemSnapshot result = (ItemSnapshot)this.campfireRecipesCache.get((Object)input);
        return result.type() == Item.AIR ? Optional.empty() : Optional.of(result);
    }

    @Override
    public Collection<ItemSnapshot> calculateOptimalOreDrops(Block block) {
        World world = PlatformAdapter.toBukkitWorld(block.world());
        BlockState blockState = world.getBlockState(block.blockX(), block.blockY(), block.blockZ());
        if (MaterialTags.ORES.isTagged(blockState)) {
            ItemStack item = new ItemStack(Material.DIAMOND_PICKAXE);
            item.addEnchantment(Enchantment.FORTUNE, 2);
            return blockState.getDrops(item).stream().map(PlatformAdapter::fromBukkitItem).toList();
        }
        return List.of();
    }

    private ItemSnapshot findCampfireRecipe(Item item) {
        ItemStack bukkitItem = PlatformAdapter.toBukkitItem(item);
        Iterator iterator = Bukkit.recipeIterator();
        while (iterator.hasNext()) {
            CampfireRecipe recipe;
            Object e = iterator.next();
            if (!(e instanceof CampfireRecipe) || !(recipe = (CampfireRecipe)e).getInputChoice().test(bukkitItem)) continue;
            return PlatformAdapter.fromBukkitItem(recipe.getResult());
        }
        return ItemSnapshot.AIR.get();
    }
}

