/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform;

import java.util.Map;
import java.util.Objects;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.damage.DamageCause;
import me.moros.bending.api.platform.entity.DelegateEntity;
import me.moros.bending.api.platform.entity.DelegateLivingEntity;
import me.moros.bending.api.platform.entity.DelegatePlayer;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.GameMode;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.potion.Potion;
import me.moros.bending.api.platform.potion.PotionEffectTag;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.paper.platform.block.BukkitBlockState;
import me.moros.bending.paper.platform.entity.BukkitEntity;
import me.moros.bending.paper.platform.entity.BukkitLivingEntity;
import me.moros.bending.paper.platform.entity.BukkitPlayer;
import me.moros.bending.paper.platform.item.BukkitItem;
import me.moros.bending.paper.platform.world.BukkitWorld;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlatformAdapter {
    public static final Map<Class<?>, PersistentDataType<?, ?>> PERSISTENT_DATA_TYPE_MAP = Map.ofEntries(PlatformAdapter.entry(PersistentDataType.SHORT), PlatformAdapter.entry(PersistentDataType.FLOAT), PlatformAdapter.entry(PersistentDataType.DOUBLE), PlatformAdapter.entry(PersistentDataType.BOOLEAN), PlatformAdapter.entry(PersistentDataType.STRING), PlatformAdapter.entry(PersistentDataType.BYTE), PlatformAdapter.entry(PersistentDataType.BYTE_ARRAY), PlatformAdapter.entry(PersistentDataType.INTEGER), PlatformAdapter.entry(PersistentDataType.INTEGER_ARRAY), PlatformAdapter.entry(PersistentDataType.LONG), PlatformAdapter.entry(PersistentDataType.LONG_ARRAY), PlatformAdapter.entry(PersistentDataType.TAG_CONTAINER), PlatformAdapter.entry(PersistentDataType.TAG_CONTAINER_ARRAY));

    private PlatformAdapter() {
    }

    private static Map.Entry<Class<?>, PersistentDataType<?, ?>> entry(PersistentDataType<?, ?> type) {
        return Map.entry(type.getComplexType(), type);
    }

    public static PotionEffectType toBukkitPotion(me.moros.bending.api.platform.potion.PotionEffect effect) {
        return Objects.requireNonNull((PotionEffectType)Registry.POTION_EFFECT_TYPE.get(PlatformAdapter.nsk(effect.key())));
    }

    public static PotionEffect toBukkitPotion(Potion p) {
        return new PotionEffect(PlatformAdapter.toBukkitPotion(p.effect()), p.duration(), p.amplifier(), p.ambient(), p.particles(), p.icon());
    }

    public static Potion fromBukkitPotion(PotionEffect p) {
        me.moros.bending.api.platform.potion.PotionEffect effect = me.moros.bending.api.platform.potion.PotionEffect.registry().getOrThrow(p.getType().key());
        return Potion.builder(effect).duration(p.getDuration()).amplifier(p.getAmplifier()).ambient(p.isAmbient()).particles(p.hasParticles()).icon(p.hasIcon()).build();
    }

    public static PotionEffectTag potionCategory(PotionEffectType type) {
        return switch (type.getEffectCategory()) {
            default -> throw new MatchException(null, null);
            case PotionEffectType.Category.BENEFICIAL -> PotionEffectTag.BENEFICIAL;
            case PotionEffectType.Category.NEUTRAL -> PotionEffectTag.NEUTRAL;
            case PotionEffectType.Category.HARMFUL -> PotionEffectTag.HARMFUL;
        };
    }

    public static Item fromBukkitItem(Material material) {
        Item item = Item.registry().get(material.key());
        if (item == null || !material.isItem()) {
            throw new IllegalStateException(material.name() + " is not a valid item.");
        }
        return item;
    }

    public static BlockType fromBukkitBlock(Material material) {
        BlockType blockType = BlockType.registry().get(material.key());
        if (blockType == null || !material.isBlock()) {
            throw new IllegalStateException(material.name() + " is not a valid block type.");
        }
        return blockType;
    }

    public static Material toBukkitItemMaterial(Item item) {
        Material mat = (Material)Registry.MATERIAL.get(PlatformAdapter.nsk(item.key()));
        if (mat == null || !mat.isItem()) {
            throw new IllegalStateException(String.valueOf(item.key()) + " is not a valid item.");
        }
        return mat;
    }

    public static ItemStack toBukkitItem(Item item) {
        return new ItemStack(PlatformAdapter.toBukkitItemMaterial(item));
    }

    public static ItemStack toBukkitItem(ItemSnapshot item) {
        ItemStack stack = ((BukkitItem)item).copy();
        stack.setAmount(item.amount());
        return stack;
    }

    public static ItemSnapshot fromBukkitItem(@Nullable ItemStack itemStack) {
        return itemStack == null ? ItemSnapshot.AIR.get() : new BukkitItem(itemStack);
    }

    public static NamespacedKey nsk(Key key) {
        NamespacedKey nsk;
        return key instanceof NamespacedKey ? (nsk = (NamespacedKey)key) : new NamespacedKey(key.namespace(), key.value());
    }

    public static <T> @Nullable PersistentDataType<?, T> dataType(DataKey<T> key) {
        return PERSISTENT_DATA_TYPE_MAP.get(key.type());
    }

    public static World fromBukkitWorld(org.bukkit.World world) {
        return new BukkitWorld(world);
    }

    public static org.bukkit.World toBukkitWorld(World world) {
        return ((BukkitWorld)world).handle();
    }

    public static Block fromBukkitBlock(org.bukkit.block.Block block) {
        return PlatformAdapter.fromBukkitWorld(block.getWorld()).blockAt(block.getX(), block.getY(), block.getZ());
    }

    public static me.moros.bending.api.platform.entity.Entity fromBukkitEntity(Entity entity) {
        if (entity instanceof org.bukkit.entity.Player) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity;
            return PlatformAdapter.fromBukkitEntity(player);
        }
        if (entity instanceof org.bukkit.entity.LivingEntity) {
            org.bukkit.entity.LivingEntity living = (org.bukkit.entity.LivingEntity)entity;
            return PlatformAdapter.fromBukkitEntity(living);
        }
        return new BukkitEntity(entity);
    }

    public static LivingEntity fromBukkitEntity(org.bukkit.entity.LivingEntity entity) {
        if (entity instanceof org.bukkit.entity.Player) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)entity;
            return PlatformAdapter.fromBukkitEntity(player);
        }
        return new BukkitLivingEntity(entity);
    }

    public static Player fromBukkitEntity(org.bukkit.entity.Player entity) {
        return new BukkitPlayer(entity);
    }

    public static Entity toBukkitEntity(me.moros.bending.api.platform.entity.Entity entity) {
        if (entity instanceof DelegateEntity) {
            DelegateEntity delegate = (DelegateEntity)entity;
            return PlatformAdapter.toBukkitEntity(delegate.entity());
        }
        return ((BukkitEntity)entity).handle();
    }

    public static org.bukkit.entity.LivingEntity toBukkitEntity(LivingEntity entity) {
        if (entity instanceof DelegateLivingEntity) {
            DelegateLivingEntity delegate = (DelegateLivingEntity)entity;
            return PlatformAdapter.toBukkitEntity(delegate.entity());
        }
        return ((BukkitLivingEntity)entity).handle();
    }

    public static org.bukkit.entity.Player toBukkitEntity(Player player) {
        if (player instanceof DelegatePlayer) {
            DelegatePlayer delegate = (DelegatePlayer)player;
            return PlatformAdapter.toBukkitEntity(delegate.entity());
        }
        return ((BukkitPlayer)player).handle();
    }

    public static DamageCause fromBukkitCause(EntityDamageEvent.DamageCause cause) {
        return switch (cause) {
            case EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK -> DamageCause.FIRE;
            case EntityDamageEvent.DamageCause.FALL -> DamageCause.FALL;
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> DamageCause.KINETIC;
            case EntityDamageEvent.DamageCause.SUFFOCATION -> DamageCause.SUFFOCATION;
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> DamageCause.EXPLOSION;
            default -> DamageCause.CUSTOM;
        };
    }

    public static BlockState fromBukkitData(BlockData data) {
        return new BukkitBlockState(data);
    }

    public static BlockData toBukkitData(BlockState state) {
        return ((BukkitBlockState)state).handle();
    }

    public static GameMode fromBukkitGameMode(org.bukkit.GameMode gameMode) {
        return switch (gameMode) {
            default -> throw new MatchException(null, null);
            case org.bukkit.GameMode.SURVIVAL -> GameMode.SURVIVAL;
            case org.bukkit.GameMode.CREATIVE -> GameMode.CREATIVE;
            case org.bukkit.GameMode.ADVENTURE -> GameMode.ADVENTURE;
            case org.bukkit.GameMode.SPECTATOR -> GameMode.SPECTATOR;
        };
    }
}

