/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.item;

import me.moros.bending.api.platform.item.EquipmentSlot;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.paper.platform.PlatformAdapter;
import org.bukkit.inventory.EntityEquipment;

public class BukkitInventory
implements Inventory {
    private final EntityEquipment handle;

    public BukkitInventory(EntityEquipment handle) {
        this.handle = handle;
    }

    private EntityEquipment handle() {
        return this.handle;
    }

    @Override
    public boolean canPlaceBlock() {
        return this.handle().getItemInMainHand().getType().isBlock() || this.handle().getItemInOffHand().getType().isBlock();
    }

    @Override
    public ItemSnapshot item(EquipmentSlot slot) {
        return PlatformAdapter.fromBukkitItem(this.handle().getItem(BukkitInventory.toBukkit(slot)));
    }

    @Override
    public void item(EquipmentSlot slot, ItemSnapshot item) {
        this.handle().setItem(BukkitInventory.toBukkit(slot), PlatformAdapter.toBukkitItem(item));
    }

    protected static org.bukkit.inventory.EquipmentSlot toBukkit(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND -> org.bukkit.inventory.EquipmentSlot.HAND;
            case EquipmentSlot.OFFHAND -> org.bukkit.inventory.EquipmentSlot.OFF_HAND;
            case EquipmentSlot.FEET -> org.bukkit.inventory.EquipmentSlot.FEET;
            case EquipmentSlot.LEGS -> org.bukkit.inventory.EquipmentSlot.LEGS;
            case EquipmentSlot.CHEST -> org.bukkit.inventory.EquipmentSlot.CHEST;
            case EquipmentSlot.HEAD -> org.bukkit.inventory.EquipmentSlot.HEAD;
        };
    }
}

