/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.platform.item;

import java.util.Optional;
import java.util.function.Supplier;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.Suppliers;
import me.moros.bending.paper.platform.BukkitPersistentDataHolder;
import me.moros.bending.paper.platform.PlatformAdapter;
import org.bukkit.inventory.ItemStack;

public final class BukkitItem
implements ItemSnapshot {
    private final Item type;
    private final ItemStack handle;
    private final Supplier<DataHolder> holderSupplier;
    private final int hashcode;

    public BukkitItem(ItemStack handle) {
        this.type = PlatformAdapter.fromBukkitItem(handle.getType());
        this.handle = handle.clone();
        this.holderSupplier = Suppliers.lazy(() -> BukkitPersistentDataHolder.create(this.handle));
        this.hashcode = this.handle.hashCode();
    }

    public ItemStack copy() {
        return this.handle.clone();
    }

    @Override
    public Item type() {
        return this.type;
    }

    @Override
    public int amount() {
        return this.handle.getAmount();
    }

    @Override
    public <T> Optional<T> get(DataKey<T> key) {
        return this.holderSupplier.get().get(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.handle.equals((Object)((BukkitItem)obj).handle);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

