/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.oneiricconcept.block;

import net.mcreator.oneiricconcept.init.OneiricconceptModBlocks;
import net.mcreator.oneiricconcept.procedures.BlockmodeProcedure;
import net.mcreator.oneiricconcept.procedures.BreakDropsProcedure;
import net.mcreator.oneiricconcept.procedures.SupportdownProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class Anemo1Block
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)9);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public Anemo1Block() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.EMERALD).sound(SoundType.METAL).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 4) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 5) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 6) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 7) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 8) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 9) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)3.5, (double)0.0, (double)4.5, (double)12.5, (double)2.0, (double)11.5);
                case Direction.NORTH -> Anemo1Block.box((double)3.5, (double)0.0, (double)4.5, (double)12.5, (double)2.0, (double)11.5);
                case Direction.EAST -> Anemo1Block.box((double)4.5, (double)0.0, (double)3.5, (double)11.5, (double)2.0, (double)12.5);
                case Direction.WEST -> Anemo1Block.box((double)4.5, (double)0.0, (double)3.5, (double)11.5, (double)2.0, (double)12.5);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)4.5, (double)15.0, (double)2.0, (double)11.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)4.5, (double)15.0, (double)2.0, (double)11.5);
                case Direction.EAST -> Anemo1Block.box((double)4.5, (double)0.0, (double)1.0, (double)11.5, (double)2.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)4.5, (double)0.0, (double)1.0, (double)11.5, (double)2.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 3) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)2.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)2.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)2.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)2.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 4) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)2.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)2.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)2.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)2.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 5) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)2.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)2.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)2.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)2.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 6) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 7) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 8) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 9) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.NORTH -> Anemo1Block.box((double)1.0, (double)0.0, (double)0.5, (double)15.0, (double)4.0, (double)15.5);
                case Direction.EAST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
                case Direction.WEST -> Anemo1Block.box((double)0.5, (double)0.0, (double)1.0, (double)15.5, (double)4.0, (double)15.0);
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Anemo1Block.box((double)6.0, (double)0.0, (double)4.5, (double)10.0, (double)2.0, (double)11.5);
            case Direction.NORTH -> Anemo1Block.box((double)6.0, (double)0.0, (double)4.5, (double)10.0, (double)2.0, (double)11.5);
            case Direction.EAST -> Anemo1Block.box((double)4.5, (double)0.0, (double)6.0, (double)11.5, (double)2.0, (double)10.0);
            case Direction.WEST -> Anemo1Block.box((double)4.5, (double)0.0, (double)6.0, (double)11.5, (double)2.0, (double)10.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return SupportdownProcedure.execute(world, x, y, z);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        SupportdownProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        BreakDropsProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        return retval;
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        BlockmodeProcedure.execute((LevelAccessor)world, x, y, z, blockstate, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().register((bs, world, pos, index) -> world != null && pos != null ? ((Biome)Minecraft.getInstance().level.getBiome(pos).value()).getSkyColor() : 8562943, new Block[]{(Block)OneiricconceptModBlocks.ANEMO_METAL.get()});
    }
}

