/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.oneiricconcept.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.mcreator.oneiricconcept.init.OneiricconceptModScreens;
import net.mcreator.oneiricconcept.procedures.GetPhaseProcedure;
import net.mcreator.oneiricconcept.procedures.GetPhaseTextProcedure;
import net.mcreator.oneiricconcept.procedures.WhiteMoonlightAbsorbProcedure;
import net.mcreator.oneiricconcept.world.inventory.WhiteMoonlightAbsorberGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class WhiteMoonlightAbsorberGUIScreen
extends AbstractContainerScreen<WhiteMoonlightAbsorberGUIMenu>
implements OneiricconceptModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"oneiricconcept:textures/screens/white_moonlight_absorber_gui.png");

    public WhiteMoonlightAbsorberGUIScreen(WhiteMoonlightAbsorberGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean customTooltipShown = false;
        if (mouseX > this.leftPos + 76 && mouseX < this.leftPos + 100 && mouseY > this.topPos + 5 && mouseY < this.topPos + 29) {
            String hoverText = GetPhaseTextProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z);
            if (hoverText != null) {
                guiGraphics.renderComponentTooltip(this.font, Arrays.stream(hoverText.split("\n")).map(Component::literal).collect(Collectors.toList()), mouseX, mouseY);
            }
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"oneiricconcept:textures/screens/phase.png"), this.leftPos + 84, this.topPos + 17, (float)Mth.clamp((int)((int)GetPhaseProcedure.execute((LevelAccessor)this.world) * 8), (int)0, (int)32), 0.0f, 8, 8, 40, 8);
        guiGraphics.blit(ResourceLocation.parse((String)"oneiricconcept:textures/screens/moonlight.png"), this.leftPos + 84, this.topPos + 29, (float)Mth.clamp((int)((int)WhiteMoonlightAbsorbProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) * 8), (int)0, (int)240), 0.0f, 8, 30, 248, 30);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
    }
}

