/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.oneiricconcept.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.oneiricconcept.client.model.ModelBaryon;
import net.mcreator.oneiricconcept.client.model.animations.BaryonAnimation;
import net.mcreator.oneiricconcept.entity.BaryonEntity;
import net.mcreator.oneiricconcept.procedures.EntitytexturesProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BaryonRenderer
extends MobRenderer<BaryonEntity, ModelBaryon<BaryonEntity>> {
    public BaryonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelBaryon.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<BaryonEntity, ModelBaryon<BaryonEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"oneiricconcept:textures/entities/antibaryon.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, BaryonEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (EntitytexturesProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelBaryon)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(BaryonEntity entity) {
        return ResourceLocation.parse((String)"oneiricconcept:textures/entities/baryon.png");
    }

    private static final class AnimatedModel
    extends ModelBaryon<BaryonEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BaryonEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BaryonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, BaryonAnimation.animation, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BaryonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

