/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.oneiricconcept.entity;

import net.mcreator.oneiricconcept.init.OneiricconceptModBlocks;
import net.mcreator.oneiricconcept.init.OneiricconceptModEntities;
import net.mcreator.oneiricconcept.procedures.CrystalHeadProcedure;
import net.mcreator.oneiricconcept.procedures.CrystalTurtleTickProcedure;
import net.mcreator.oneiricconcept.procedures.ShrinkingShellSuoKeProcedure;
import net.mcreator.oneiricconcept.procedures.TurtleDamageProcedure;
import net.mcreator.oneiricconcept.procedures.UnShrinkingShellProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class CrystalTurtleEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_ShrinkingShellTime = SynchedEntityData.defineId(CrystalTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_crystal = SynchedEntityData.defineId(CrystalTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_IsShrinking = SynchedEntityData.defineId(CrystalTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsCrystallized = SynchedEntityData.defineId(CrystalTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsUnShrinking = SynchedEntityData.defineId(CrystalTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public CrystalTurtleEntity(EntityType<CrystalTurtleEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (CrystalTurtleEntity.this.isInWater()) {
                    CrystalTurtleEntity.this.setDeltaMovement(CrystalTurtleEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !CrystalTurtleEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - CrystalTurtleEntity.this.getX();
                    double dy = this.wantedY - CrystalTurtleEntity.this.getY();
                    double dz = this.wantedZ - CrystalTurtleEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * CrystalTurtleEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    CrystalTurtleEntity.this.setYRot(this.rotlerp(CrystalTurtleEntity.this.getYRot(), f, 10.0f));
                    CrystalTurtleEntity.this.yBodyRot = CrystalTurtleEntity.this.getYRot();
                    CrystalTurtleEntity.this.yHeadRot = CrystalTurtleEntity.this.getYRot();
                    if (CrystalTurtleEntity.this.isInWater()) {
                        CrystalTurtleEntity.this.setSpeed((float)CrystalTurtleEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        CrystalTurtleEntity.this.setXRot(this.rotlerp(CrystalTurtleEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(CrystalTurtleEntity.this.getXRot() * ((float)Math.PI / 180)));
                        CrystalTurtleEntity.this.setZza(f3 * f1);
                        CrystalTurtleEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        CrystalTurtleEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    CrystalTurtleEntity.this.setSpeed(0.0f);
                    CrystalTurtleEntity.this.setYya(0.0f);
                    CrystalTurtleEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ShrinkingShellTime, (Object)0);
        builder.define(DATA_crystal, (Object)0);
        builder.define(DATA_IsShrinking, (Object)false);
        builder.define(DATA_IsCrystallized, (Object)false);
        builder.define(DATA_IsUnShrinking, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FollowParentGoal(this, 0.8){

            public boolean canUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canContinueToUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canContinueToUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canContinueToUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new TryFindWaterGoal((PathfinderMob)this){

            public boolean canUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystalTurtleEntity.this.getX();
                double y = CrystalTurtleEntity.this.getY();
                double z = CrystalTurtleEntity.this.getZ();
                CrystalTurtleEntity entity = CrystalTurtleEntity.this;
                Level world = CrystalTurtleEntity.this.level();
                return super.canContinueToUse() && UnShrinkingShellProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CrystalTurtleEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (!TurtleDamageProcedure.execute((LevelAccessor)world, x, y, z, damagesource, (Entity)entity)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        TurtleDamageProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), source, (Entity)this);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataShrinkingShellTime", ((Integer)this.entityData.get(DATA_ShrinkingShellTime)).intValue());
        compound.putInt("Datacrystal", ((Integer)this.entityData.get(DATA_crystal)).intValue());
        compound.putBoolean("DataIsShrinking", ((Boolean)this.entityData.get(DATA_IsShrinking)).booleanValue());
        compound.putBoolean("DataIsCrystallized", ((Boolean)this.entityData.get(DATA_IsCrystallized)).booleanValue());
        compound.putBoolean("DataIsUnShrinking", ((Boolean)this.entityData.get(DATA_IsUnShrinking)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataShrinkingShellTime")) {
            this.entityData.set(DATA_ShrinkingShellTime, (Object)compound.getInt("DataShrinkingShellTime"));
        }
        if (compound.contains("Datacrystal")) {
            this.entityData.set(DATA_crystal, (Object)compound.getInt("Datacrystal"));
        }
        if (compound.contains("DataIsShrinking")) {
            this.entityData.set(DATA_IsShrinking, (Object)compound.getBoolean("DataIsShrinking"));
        }
        if (compound.contains("DataIsCrystallized")) {
            this.entityData.set(DATA_IsCrystallized, (Object)compound.getBoolean("DataIsCrystallized"));
        }
        if (compound.contains("DataIsUnShrinking")) {
            this.entityData.set(DATA_IsUnShrinking, (Object)compound.getBoolean("DataIsUnShrinking"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState2.animateWhen(ShrinkingShellSuoKeProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(UnShrinkingShellProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(CrystalHeadProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CrystalTurtleTickProcedure.execute((Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        CrystalTurtleEntity retval = (CrystalTurtleEntity)((EntityType)OneiricconceptModEntities.CRYSTAL_TURTLE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)OneiricconceptModBlocks.PRIMOGEM.get())}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CrystalTurtleEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)OneiricconceptModEntities.CRYSTAL_TURTLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.9);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.2);
        return builder;
    }
}

