/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.oneiricconcept.item;

import net.mcreator.oneiricconcept.entity.InvalidEntity;
import net.mcreator.oneiricconcept.procedures.MoraLaunchProcedure;
import net.mcreator.oneiricconcept.procedures.MoraOnlineProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BossStoneCoinGunItem
extends Item {
    public BossStoneCoinGunItem() {
        super(new Item.Properties().stacksTo(1).fireResistant());
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 32;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.fail((Object)entity.getItemInHand(hand));
        if (MoraOnlineProcedure.execute((Entity)entity) && (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY)) {
            ar = InteractionResultHolder.success((Object)entity.getItemInHand(hand));
            entity.startUsingItem(hand);
        }
        return ar;
    }

    public void onUseTick(Level world, LivingEntity entity, ItemStack itemstack, int count) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                InvalidEntity projectile = InvalidEntity.shoot(world, entity, world.getRandom());
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
                MoraLaunchProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity);
            }
            entity.releaseUsingItem();
        }
    }

    private ItemStack findAmmo(Player player) {
        return new ItemStack((ItemLike)InvalidEntity.PROJECTILE_ITEM.getItem());
    }
}

