/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.compat.alekiships;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractAlekiBoatEntity;
import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import com.leclowndu93150.wakes.mixin.AlekiBoatAccessor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;

public class AlekiShipsCompat {
    private static Boolean alekiShipsLoaded = null;

    public static boolean isAlekiShipsLoaded() {
        if (alekiShipsLoaded == null) {
            alekiShipsLoaded = FMLLoader.getLoadingModList().getModFileById("alekiships") != null;
        }
        return alekiShipsLoaded;
    }

    public static boolean isAlekiShipsBoat(Object entity) {
        if (!AlekiShipsCompat.isAlekiShipsLoaded()) {
            return false;
        }
        return entity instanceof AbstractAlekiBoatEntity;
    }

    public static PaddleInfo getPaddleInfo(AbstractAlekiBoatEntity boat, float partialTicks, float wakeHeight) {
        if (boat instanceof RowboatEntity) {
            RowboatEntity rowboat = (RowboatEntity)boat;
            return AlekiShipsCompat.getRowboatPaddleInfo(rowboat, partialTicks, wakeHeight);
        }
        if (boat instanceof SloopEntity) {
            SloopEntity sloop = (SloopEntity)boat;
            return AlekiShipsCompat.getSloopPaddleInfo(sloop, partialTicks, wakeHeight);
        }
        return new PaddleInfo(new Vec3[0], new boolean[0]);
    }

    private static PaddleInfo getRowboatPaddleInfo(RowboatEntity rowboat, float partialTicks, float wakeHeight) {
        if (rowboat.getOars() == RowboatEntity.Oars.ZERO) {
            return new PaddleInfo(new Vec3[0], new boolean[0]);
        }
        int oarCount = rowboat.getOars() == RowboatEntity.Oars.TWO ? 2 : 1;
        Vec3[] paddlePositions = new Vec3[oarCount];
        boolean[] inWater = new boolean[oarCount];
        float yaw = rowboat.m_146908_();
        float yawRad = (float)Math.toRadians(yaw);
        for (int i = 0; i < oarCount; ++i) {
            boolean isPaddleInWaterPhase;
            if (!rowboat.getPaddleState(i)) {
                paddlePositions[i] = new Vec3(rowboat.m_20185_(), rowboat.m_20186_(), rowboat.m_20189_());
                inWater[i] = false;
                continue;
            }
            float rowingTime = rowboat.getRowingTime(i, partialTicks);
            Vec3 viewVector = rowboat.m_20252_(1.0f);
            float[] paddlePositionsArray = ((AlekiBoatAccessor)rowboat).wakes$getPaddlePositions();
            float paddlePhase = (float)((double)paddlePositionsArray[i] % (Math.PI * 2));
            float oarPivotOffset = 0.90625f;
            float oarBladeEndOffset = 2.2421875f;
            float paddleSwing = (Mth.m_14031_((float)(-rowingTime)) + 1.0f) / 2.0f;
            float yRotation = Mth.m_144920_((float)0.7853982f, (float)-0.7853982f, (float)((Mth.m_14031_((float)(-rowingTime + 1.0f)) + 1.0f) / 2.0f));
            if (i == 1) {
                yRotation = -yRotation;
            }
            float totalDistance = oarPivotOffset + oarBladeEndOffset;
            double perpX = i == 1 ? -viewVector.f_82481_ : viewVector.f_82481_;
            double perpZ = i == 1 ? viewVector.f_82479_ : -viewVector.f_82479_;
            double rotatedX = perpX * (double)Mth.m_14089_((float)yRotation) - viewVector.f_82479_ * (double)Mth.m_14031_((float)yRotation);
            double rotatedZ = perpZ * (double)Mth.m_14089_((float)yRotation) - viewVector.f_82481_ * (double)Mth.m_14031_((float)yRotation);
            float worldX = (float)(rowboat.m_20185_() + rotatedX * (double)totalDistance);
            float worldY = wakeHeight;
            float worldZ = (float)(rowboat.m_20189_() + rotatedZ * (double)totalDistance);
            paddlePositions[i] = new Vec3((double)worldX, (double)worldY, (double)worldZ);
            double PADDLE_SPEED = 0.39269908169872414;
            double PADDLE_SOUND_TIME = 0.7853981633974483;
            inWater[i] = isPaddleInWaterPhase = (double)paddlePhase >= PADDLE_SPEED / 2.0 && (double)paddlePhase <= PADDLE_SOUND_TIME + PADDLE_SPEED;
        }
        return new PaddleInfo(paddlePositions, inWater);
    }

    private static PaddleInfo getSloopPaddleInfo(SloopEntity sloop, float partialTicks, float wakeHeight) {
        return new PaddleInfo(new Vec3[0], new boolean[0]);
    }

    public static BoatDimensions getBoatDimensions(AbstractAlekiBoatEntity boat) {
        if (boat instanceof RowboatEntity) {
            return new BoatDimensions(1.8f, -1.2f, 0.8f);
        }
        if (boat instanceof SloopEntity) {
            return new BoatDimensions(3.5f, -3.0f, 1.5f);
        }
        float bbWidth = boat.m_20205_();
        float bbHeight = boat.m_20206_();
        return new BoatDimensions(bbWidth * 0.4f, -bbWidth * 0.4f, bbWidth * 0.5f);
    }

    public record PaddleInfo(Vec3[] positions, boolean[] inWater) {
    }

    public record BoatDimensions(float front, float back, float width) {
    }
}

