/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.compat.valkyrienskies;

import com.leclowndu93150.wakes.compat.valkyrienskies.DynamicWakeSize;
import com.leclowndu93150.wakes.compat.valkyrienskies.VSUtils;
import com.leclowndu93150.wakes.compat.valkyrienskies.ValkyrienSkiesCompat;
import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ShipWake {
    private static final int MAX_WIDTH = 24;

    public static void placeWakeTrail(Ship ship) {
        block8: {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            WakeHandler wakeHandler = WakeHandler.getInstance((Level)Minecraft.m_91087_().f_91073_).orElse(null);
            if (wakeHandler == null) break block8;
            ProducesWake producer = (ProducesWake)ship;
            double velocity = producer.wakes$getHorizontalVelocity();
            float height = producer.wakes$wakeHeight().floatValue();
            Vec3 prevPos = producer.wakes$getPrevPos();
            if (prevPos != null) {
                int maxSegmentLength;
                float width = ((DynamicWakeSize)ship).getWidth();
                if (width > 24.0f) {
                    return;
                }
                double toX = ((DynamicWakeSize)ship).getPos().f_82479_;
                double dx = toX - prevPos.f_82479_;
                double toZ = ((DynamicWakeSize)ship).getPos().f_82481_;
                double dz = toZ - prevPos.f_82481_;
                double distance = Math.sqrt(dx * dx + dz * dz);
                if (distance > (double)(maxSegmentLength = 10)) {
                    int segments = (int)Math.ceil(distance / (double)maxSegmentLength);
                    for (int i = 0; i < segments; ++i) {
                        double t1 = (double)i / (double)segments;
                        double t2 = (double)(i + 1) / (double)segments;
                        double x1 = prevPos.f_82479_ + dx * t1;
                        double z1 = prevPos.f_82481_ + dz * t1;
                        double x2 = prevPos.f_82479_ + dx * t2;
                        double z2 = prevPos.f_82481_ + dz * t2;
                        for (WakeNode node : WakeNode.Factory.thickNodeTrail(x1, z1, x2, z2, (int)Math.floor(height), ((Integer)WakesConfig.GENERAL.initialStrength.get()).intValue(), velocity, width)) {
                            wakeHandler.insert(node);
                        }
                    }
                } else {
                    for (WakeNode node : WakeNode.Factory.thickNodeTrail(prevPos.f_82479_, prevPos.f_82481_, toX, toZ, (int)Math.floor(height), ((Integer)WakesConfig.GENERAL.initialStrength.get()).intValue(), velocity, width)) {
                        wakeHandler.insert(node);
                    }
                }
            }
        }
    }

    public static void checkShipSize(Ship s) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Vector3d horizontalVelocity = new Vector3d(s.getVelocity().x(), 0.0, s.getVelocity().z());
        if (horizontalVelocity.length() < 0.05) {
            return;
        }
        double velAngle = horizontalVelocity.angleSigned((Vector3dc)new Vector3d(0.0, 0.0, -1.0), (Vector3dc)new Vector3d(0.0, 1.0, 0.0));
        double shipAngle = VSUtils.getYaw(s.getTransform().getShipToWorldRotation());
        Direction direction = VSUtils.approximateDirection(Math.toDegrees(velAngle - shipAngle));
        Vec3 shipPos = VSUtils.getCentre(s.getWorldAABB());
        Double yLevelShip = VectorConversionsMCKt.toJOML((Vec3)new Vec3((double)shipPos.f_82479_, (double)ValkyrienSkiesCompat.getSeaLevel(), (double)shipPos.f_82481_)).mulPosition((Matrix4dc)s.getWorldToShip()).y;
        int blockYLevelShip = yLevelShip.intValue();
        Vector3i minWorldPos = new Vector3i();
        Vector3i maxWorldPos = new Vector3i();
        int minY = blockYLevelShip / 16 * 16;
        int maxY = blockYLevelShip / 16 * 16 + 15;
        s.getActiveChunksSet().getMinMaxWorldPos(minWorldPos, maxWorldPos, new LevelYRange(minY, maxY));
        AABBic shipBounds = s.getShipAABB();
        assert (shipBounds != null);
        int shipX = shipBounds.maxX() - shipBounds.minX();
        int shipZ = shipBounds.maxZ() - shipBounds.minZ();
        if ((direction == Direction.NORTH || direction == Direction.SOUTH) && shipX > shipZ) {
            ((DynamicWakeSize)s).setWidth(0.0f);
            return;
        }
        if ((direction == Direction.EAST || direction == Direction.WEST) && shipZ > shipX) {
            ((DynamicWakeSize)s).setWidth(0.0f);
            return;
        }
        ShipWake.calculateShipWidthAndOffset((Level)level, minWorldPos, maxWorldPos, blockYLevelShip, direction, s);
    }

    private static void calculateShipWidthAndOffset(Level level, Vector3i minWorldPos, Vector3i maxWorldPos, int blockYLevelShip, Direction direction, Ship s) {
        int primary;
        boolean isZAxis = direction == Direction.NORTH || direction == Direction.SOUTH;
        int primaryMin = isZAxis ? minWorldPos.z() : minWorldPos.x();
        int primaryMax = isZAxis ? maxWorldPos.z() : maxWorldPos.x();
        int secondaryMin = isZAxis ? minWorldPos.x() : minWorldPos.z();
        int secondaryMax = isZAxis ? maxWorldPos.x() : maxWorldPos.z();
        boolean isNegativeDirection = direction == Direction.NORTH || direction == Direction.WEST;
        ArrayList rows = new ArrayList();
        int n = primary = isNegativeDirection ? primaryMax : primaryMin;
        while (isNegativeDirection ? primary >= primaryMin : primary <= primaryMax) {
            LinkedList<BlockPos> blockPositions = new LinkedList<BlockPos>();
            for (int secondary = secondaryMin; secondary <= secondaryMax; ++secondary) {
                int z;
                int n2 = isZAxis ? secondary : primary;
                int n3 = z = isZAxis ? primary : secondary;
                if (level.m_8055_(new BlockPos(n2, blockYLevelShip, z)).m_60795_()) continue;
                blockPositions.add(new BlockPos(n2, blockYLevelShip, z));
            }
            if (!blockPositions.isEmpty()) {
                rows.add(blockPositions);
            }
            if (rows.size() >= 5) break;
            primary += isNegativeDirection ? -1 : 1;
        }
        float width = 0.0f;
        Vector3d offset = new Vector3d();
        for (LinkedList linkedList : rows) {
            float rowWidth = ShipWake.getWidth(linkedList);
            if (!(rowWidth > width) || !(rowWidth <= 24.0f)) continue;
            width = rowWidth;
            offset = ShipWake.getOffset(linkedList);
            offset = new Vector3d(offset.x, 0.0, offset.z);
        }
        ((DynamicWakeSize)s).setWidth(width);
        if (!offset.equals(0.0, 0.0, 0.0)) {
            Vector3d vector3d = VSUtils.getCentre(Objects.requireNonNull(s.getShipAABB()));
            Vector3d offsetReal = new Vector3d(vector3d.x, 0.0, vector3d.z).sub((Vector3dc)offset);
            ((DynamicWakeSize)s).setOffset(offsetReal.negate());
        }
    }

    private static int getWidth(LinkedList<BlockPos> blockPositions) {
        if (blockPositions.isEmpty()) {
            return 0;
        }
        return blockPositions.getFirst().m_123333_((Vec3i)blockPositions.getLast()) + 1;
    }

    private static Vector3d getOffset(LinkedList<BlockPos> blockPositions) {
        if (blockPositions.isEmpty()) {
            return new Vector3d();
        }
        Vec3 first = Vec3.m_82512_((Vec3i)((Vec3i)blockPositions.getFirst()));
        Vec3 last = Vec3.m_82512_((Vec3i)((Vec3i)blockPositions.getLast()));
        return VSUtils.averageVec(first, last);
    }
}

