/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.particle.custom;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.ModParticles;
import com.leclowndu93150.wakes.particle.WithOwnerParticleType;
import com.leclowndu93150.wakes.simulation.SimulationNode;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.utils.WakesUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.lwjgl.system.MemoryUtil;

public class SplashPlaneParticle
extends Particle {
    public Entity owner;
    float yaw;
    float prevYaw;
    Vec3 direction = Vec3.f_82478_;
    private final SimulationNode simulationNode = new SimulationNode.SplashPlaneSimulation();
    public long imgPtr = -1L;
    public int texRes;
    public boolean hasPopulatedPixels = false;
    public boolean isRenderReady = false;
    public float lerpedYaw = 0.0f;

    protected SplashPlaneParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.initTexture(WakeHandler.resolution.res);
        WakeHandler.getInstance((Level)world).ifPresent(wakeHandler -> wakeHandler.registerSplashPlane(this));
    }

    public void m_107274_() {
        Entity entity = this.owner;
        if (entity instanceof ProducesWake) {
            ProducesWake wakeOwner = (ProducesWake)entity;
            wakeOwner.wakes$setSplashPlane(null);
        }
        this.owner = null;
        this.deallocTexture();
        super.m_107274_();
    }

    public void m_5989_() {
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue() || !WakesUtils.getEffectRuleFromSource((Entity)this.owner).renderPlanes) {
            this.m_107274_();
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.prevYaw = this.yaw;
        Entity entity = this.owner;
        if (entity instanceof ProducesWake) {
            ProducesWake wakeOwner = (ProducesWake)entity;
            if (this.owner.m_213877_() || !wakeOwner.wakes$onFluidSurface() || wakeOwner.wakes$getHorizontalVelocity() < 0.01) {
                this.m_107274_();
            } else {
                this.aliveTick(wakeOwner);
            }
        } else {
            this.m_107274_();
        }
    }

    private void aliveTick(ProducesWake wakeProducer) {
        Vec3 vel = this.owner.m_20184_();
        this.yaw = this.owner instanceof Boat ? -this.owner.m_146908_() : 90.0f - (float)(57.29577951308232 * Math.atan2(vel.f_82481_, vel.f_82479_));
        this.direction = Vec3.m_82498_((float)0.0f, (float)(-this.yaw));
        Vec3 planeOffset = this.direction.m_82490_((double)this.owner.m_20205_() + (Double)WakesConfig.APPEARANCE.splashPlaneOffset.get());
        Vec3 planePos = this.owner.m_20182_().m_82549_(planeOffset);
        this.m_107264_(planePos.f_82479_, wakeProducer.wakes$wakeHeight().floatValue(), planePos.f_82481_);
        if (vel.m_82553_() / (Double)WakesConfig.APPEARANCE.maxSplashPlaneVelocity.get() > (double)0.3f && ((Boolean)WakesConfig.APPEARANCE.spawnParticles.get()).booleanValue()) {
            Random random = new Random();
            Vec3 particleOffset = new Vec3(-this.direction.f_82481_, 0.0, this.direction.f_82479_).m_82490_(random.nextDouble() * (double)this.owner.m_20205_() / 4.0);
            Vec3 particlePos = this.owner.m_20182_().m_82549_(this.direction.m_82490_((double)this.owner.m_20205_() - 0.3));
            Vec3 particleVelocity = Vec3.m_82498_((float)((float)(45.0 * random.nextDouble())), (float)((float)((double)(-this.yaw) + 30.0 * (random.nextDouble() - 0.5)))).m_82490_(1.5 * vel.m_82553_());
            this.f_107208_.m_7106_((ParticleOptions)ModParticles.SPLASH_CLOUD.get(), particlePos.f_82479_ + particleOffset.f_82479_, this.f_107213_, particlePos.f_82481_ + particleOffset.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
            this.f_107208_.m_7106_((ParticleOptions)ModParticles.SPLASH_CLOUD.get(), particlePos.f_82479_ - particleOffset.f_82479_, this.f_107213_, particlePos.f_82481_ - particleOffset.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
        }
        this.simulationNode.tick(Float.valueOf((float)wakeProducer.wakes$getHorizontalVelocity()), null, null, null, null);
        this.populatePixels();
    }

    public void initTexture(int res) {
        long size = 4L * (long)res * (long)res;
        this.imgPtr = this.imgPtr == -1L ? MemoryUtil.nmemAlloc((long)size) : MemoryUtil.nmemRealloc((long)this.imgPtr, (long)size);
        this.texRes = res;
        this.hasPopulatedPixels = false;
    }

    public void deallocTexture() {
        MemoryUtil.nmemFree((long)this.imgPtr);
    }

    public void populatePixels() {
        int fluidColor = BiomeColors.m_108811_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.owner.m_20183_());
        int lightCoordinate = LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.owner.m_20183_());
        int lightCol = Minecraft.m_91087_().f_91063_.m_109154_().f_109871_.m_84985_(LightTexture.m_109883_((int)lightCoordinate), LightTexture.m_109894_((int)lightCoordinate));
        float opacity = ((Double)WakesConfig.APPEARANCE.wakeOpacity.get()).floatValue() * 0.9f;
        int res = WakeHandler.resolution.res;
        for (int r = 0; r < res; ++r) {
            for (int c = 0; c < res; ++c) {
                long pixelOffset = 4L * ((long)r * (long)res + (long)c);
                MemoryUtil.memPutInt((long)(this.imgPtr + pixelOffset), (int)this.simulationNode.getPixelColor(c, r, fluidColor, lightCol, opacity));
            }
        }
        this.hasPopulatedPixels = true;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        this.isRenderReady = false;
        if (this.f_107220_) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && !((Boolean)WakesConfig.APPEARANCE.firstPersonSplashPlane.get()).booleanValue() && this.owner instanceof LocalPlayer) {
            return;
        }
        float diff = this.yaw - this.prevYaw;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        this.lerpedYaw = (this.prevYaw + diff * tickDelta) % 360.0f;
        this.isRenderReady = true;
    }

    public void translateMatrix(RenderLevelStageEvent context, PoseStack matrices) {
        Vec3 cameraPos = context.getCamera().m_90583_();
        float tickDelta = context.getPartialTick();
        float x = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        matrices.m_252880_(x, y, z);
    }

    public Vec3 getPos() {
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            SplashPlaneParticle splashPlane = new SplashPlaneParticle(world, x, y, z);
            if (parameters instanceof WithOwnerParticleType) {
                WithOwnerParticleType type = (WithOwnerParticleType)parameters;
                splashPlane.owner = type.owner;
                splashPlane.yaw = splashPlane.prevYaw = type.owner.m_146908_();
                ((ProducesWake)splashPlane.owner).wakes$setSplashPlane(splashPlane);
            }
            return splashPlane;
        }
    }
}

