/*
 * Decompiled with CFR 0.152.
 */
package org.jlortiz.playercollars;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.EitherCodec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_1532;
import net.minecraft.class_1747;
import net.minecraft.class_1748;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3619;
import net.minecraft.class_4844;
import net.minecraft.class_4970;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import org.jlortiz.playercollars.OwnerComponent;
import org.jlortiz.playercollars.block.DogBedBlock;
import org.jlortiz.playercollars.block.DogBowlBlock;
import org.jlortiz.playercollars.block.InvisibleFenceBlock;
import org.jlortiz.playercollars.item.ClickerItem;
import org.jlortiz.playercollars.item.CollarItem;
import org.jlortiz.playercollars.item.CollarLockerItem;
import org.jlortiz.playercollars.item.DeedItem;
import org.jlortiz.playercollars.item.FootPawsItem;
import org.jlortiz.playercollars.item.OwnershipCraftingRecipe;
import org.jlortiz.playercollars.item.PawSetupItem;
import org.jlortiz.playercollars.item.PawsItem;
import org.jlortiz.playercollars.item.RegenerationEnchantmentEffect;
import org.jlortiz.playercollars.item.SpatulaItem;
import org.jlortiz.playercollars.item.StampedDeedItem;
import org.jlortiz.playercollars.leash.LeashImpl;
import org.jlortiz.playercollars.network.PacketLookAtLerped;
import org.jlortiz.playercollars.network.PacketOpenPawsConfig;
import org.jlortiz.playercollars.network.PacketStampDeed;
import org.jlortiz.playercollars.network.PacketUpdateCollar;
import org.jlortiz.playercollars.network.PawsConfigScreenHandler;

public class PlayerCollarsMod
implements ModInitializer {
    public static final String MOD_ID = "playercollars";
    public static final CollarItem COLLAR_ITEM = (CollarItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, CollarItem.REGISTRY_KEY, (Object)((Object)new CollarItem(false))));
    public static final CollarItem TAGLESS_COLLAR_ITEM = (CollarItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, CollarItem.TAGLESS_REGISTRY_KEY, (Object)((Object)new CollarItem(true))));
    public static final ClickerItem CLICKER_ITEM = (ClickerItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, ClickerItem.REGISTRY_KEY, (Object)((Object)new ClickerItem())));
    public static final DeedItem DEED_OF_OWNERSHIP = (DeedItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"playercollars", (String)"deed_of_ownership"), (Object)((Object)new DeedItem())));
    public static final class_1792 DEED_OF_OWNERSHIP_STAMPED = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"playercollars", (String)"stamped_deed_of_ownership"), (Object)((Object)new StampedDeedItem()));
    public static final InvisibleFenceBlock INVISIBLE_FENCE_BLOCK = (InvisibleFenceBlock)((Object)class_2378.method_39197((class_2378)class_7923.field_41175, InvisibleFenceBlock.REGISTRY_KEY, (Object)((Object)new InvisibleFenceBlock(class_4970.class_2251.method_9637().method_9634().method_9618().method_9626(class_2498.field_11544)))));
    public static final class_1747 INVISIBLE_FENCE_BLOCK_ITEM = (class_1747)class_2378.method_39197((class_2378)class_7923.field_41178, InvisibleFenceBlock.ITEM_REGISTRY_KEY, (Object)new class_1747((class_2248)INVISIBLE_FENCE_BLOCK, new class_1792.class_1793().method_63686(InvisibleFenceBlock.ITEM_REGISTRY_KEY)));
    public static final PawSetupItem PAW_CONFIGURATION_ITEM = (PawSetupItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, PawSetupItem.REGISTRY_KEY, (Object)((Object)new PawSetupItem())));
    public static final CollarLockerItem COLLAR_LOCKER_ITEM = (CollarLockerItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, CollarLockerItem.REGISTRY_KEY, (Object)((Object)new CollarLockerItem())));
    public static final SpatulaItem SPATULA_ITEM = (SpatulaItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"playercollars", (String)"golden_spatula"), (Object)((Object)new SpatulaItem())));
    public static final class_3414 CLICKER_ON = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)"playercollars", (String)"clicker_on"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)"playercollars", (String)"clicker_on")));
    public static final class_3414 CLICKER_OFF = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)class_2960.method_60655((String)"playercollars", (String)"clicker_off"), (Object)class_3414.method_47908((class_2960)class_2960.method_60655((String)"playercollars", (String)"clicker_off")));
    private static final Codec<OwnerComponent> OWNER_COMPONENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_4844.field_40825.fieldOf("uuid").forGetter(OwnerComponent::uuid), (App)Codec.STRING.fieldOf("name").forGetter(OwnerComponent::name), (App)class_5699.method_57155((Codec)class_4844.field_40825).fieldOf("owned").forGetter(OwnerComponent::owned), (App)class_5699.method_57155((Codec)Codec.STRING).fieldOf("owned_name").forGetter(OwnerComponent::ownedName)).apply((Applicative)builder, OwnerComponent::new));
    public static final class_9331<OwnerComponent> OWNER_COMPONENT_TYPE = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"playercollars", (String)"owner_component"), (Object)class_9331.method_57873().method_57881(OWNER_COMPONENT_CODEC).method_57880());
    private static final Codec<List<Either<class_6862<class_2248>, class_5321<class_2248>>>> CAN_INTERACT_COMPONENT_CODEC = Codec.withAlternative((Codec)new ListCodec((Codec)new EitherCodec(class_6862.method_40093((class_5321)class_7924.field_41254), class_5321.method_39154((class_5321)class_7924.field_41254)), 0, 1024), (Codec)Codec.of((Encoder)Encoder.error((String)"deprecated"), (Decoder)new ListCodec(class_2960.field_25139, 0, 65535).map(x -> {
        ArrayList<Either> ls = new ArrayList<Either>(x.size());
        for (class_2960 id : x) {
            ls.add(Either.right((Object)class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id)));
        }
        return ls;
    })));
    public static final class_9331<List<Either<class_6862<class_2248>, class_5321<class_2248>>>> CAN_INTERACT_COMPONENT_TYPE = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"playercollars", (String)"can_interact_component"), (Object)class_9331.method_57873().method_57881(CAN_INTERACT_COMPONENT_CODEC).method_57880());
    private static final Codec<List<Either<class_6862<class_1792>, class_5321<class_1792>>>> HELD_ITEMS_COMPONENT_CODEC = new ListCodec((Codec)new EitherCodec(class_6862.method_40093((class_5321)class_7924.field_41197), class_5321.method_39154((class_5321)class_7924.field_41197)), 0, 65535);
    public static final class_9331<List<Either<class_6862<class_1792>, class_5321<class_1792>>>> HELD_ITEMS_COMPONENT_TYPE = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"playercollars", (String)"held_items_component"), (Object)class_9331.method_57873().method_57881(HELD_ITEMS_COMPONENT_CODEC).method_57880());
    public static final class_6880<class_1320> ATTR_CLICKER_DISTANCE = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)class_2960.method_60655((String)"playercollars", (String)"clicker_distance"), (Object)new class_1329("attribute.playercollars.clicker_distance", 4.0, 0.0, 32.0));
    public static final class_6880<class_1320> ATTR_LEASH_DISTANCE = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)class_2960.method_60655((String)"playercollars", (String)"leash_distance"), (Object)new class_1329("attribute.playercollars.leash_distance", 4.0, 2.0, 16.0));
    public static final class_1928.class_4313<class_1928.class_4310> PLAYER_LEASHES_BREAK_RULE = GameRuleRegistry.register((String)"playerLeashesBreak", (class_1928.class_5198)class_1928.class_5198.field_24094, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
    public static final class_1928.class_4313<class_1928.class_4310> LEASHED_PLAYERS_RIDE_ENTITIES = GameRuleRegistry.register((String)"leashedPlayersRideEntities", (class_1928.class_5198)class_1928.class_5198.field_24094, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));
    public static final DogBedBlock[] DOG_BEDS = new DogBedBlock[class_1767.values().length];
    public static final class_1748[] DOG_BED_ITEMS = new class_1748[class_1767.values().length];
    public static final class_6862<class_1792> COLLAR_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"collars"));
    public static final class_1767[] PAWS_DYE_COLORS = new class_1767[]{class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7966, class_1767.field_7964, class_1767.field_7945};
    public static final PawsItem[] PAWS_ITEMS = new PawsItem[PAWS_DYE_COLORS.length];
    public static final class_6862<class_2248> PAWS_ALLOW_INTERACT = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"playercollars", (String)"paws_allow_interact"));
    public static final class_6862<class_1792> PAWS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"playercollars", (String)"paws"));
    public static final FootPawsItem[] FOOT_PAWS_ITEMS = new FootPawsItem[PAWS_DYE_COLORS.length];
    public static final class_6862<class_1792> FOOT_PAWS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"playercollars", (String)"foot_paws"));
    public static final DogBowlBlock[] DOG_BOWLS = new DogBowlBlock[class_1767.values().length];
    public static final class_1792[] DOG_BOWL_ITEMS = new class_1792[class_1767.values().length];
    public static final class_2591<DogBowlBlock.DogBowlBlockEntity> DOG_BOWL_BLOCK_ENTITY;
    public static final class_1761 GROUP;
    public static final ExtendedScreenHandlerType<PawsConfigScreenHandler<class_2248>, List<Either<class_6862<class_2248>, class_5321<class_2248>>>> PAWS_BLOCK_CONFIG_SCREEN_HANDLER;
    public static final ExtendedScreenHandlerType<PawsConfigScreenHandler<class_1792>, List<Either<class_6862<class_1792>, class_5321<class_1792>>>> PAWS_ITEM_CONFIG_SCREEN_HANDLER;

    public static class_1799 filterStacksByOwner(Iterable<SlotEntryReference> stacks, UUID plr, UUID entity) {
        for (SlotEntryReference p : stacks) {
            class_1799 is = p.stack();
            OwnerComponent owner = (OwnerComponent)is.method_57824(OWNER_COMPONENT_TYPE);
            if (owner == null || !owner.uuid().equals(plr) || !owner.owned().isEmpty() && !owner.owned().get().equals(entity)) continue;
            return is;
        }
        return null;
    }

    public static class_1269 pullPlayerTowards(class_3222 plr, class_243 towards, double minDist, double maxDist, UnaryOperator<Double> getFactor) {
        class_243 vecTo = towards.method_1020(plr.method_19538());
        double distance = vecTo.method_1033();
        if (distance < minDist) {
            return class_1269.field_5811;
        }
        if (distance > maxDist) {
            return class_1269.field_5814;
        }
        plr.method_60491(vecTo.method_1021(Math.abs((Double)getFactor.apply(distance))));
        plr.field_13987.method_14364((class_2596)new class_2743((class_1297)plr));
        plr.field_6007 = false;
        return class_1269.field_5812;
    }

    public void onInitialize() {
        class_2378.method_10230((class_2378)class_7923.field_51834, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"regeneration_effect"), RegenerationEnchantmentEffect.CODEC);
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"owner_transfer"), (Object)OwnershipCraftingRecipe.Serializer.INSTANCE);
        PayloadTypeRegistry.playC2S().register(PacketUpdateCollar.ID, PacketUpdateCollar.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PacketUpdateCollar.ID, PacketUpdateCollar::handle);
        PayloadTypeRegistry.playC2S().register(PacketStampDeed.ID, PacketStampDeed.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PacketStampDeed.ID, PacketStampDeed::handle);
        PayloadTypeRegistry.playC2S().register(PacketOpenPawsConfig.ID, PacketOpenPawsConfig.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PacketOpenPawsConfig.ID, PacketOpenPawsConfig::handle);
        PayloadTypeRegistry.playS2C().register(PacketLookAtLerped.ID, PacketLookAtLerped.CODEC);
        AccessoryRegistry.register((class_1792)COLLAR_ITEM, (Accessory)COLLAR_ITEM);
        AccessoryRegistry.register((class_1792)TAGLESS_COLLAR_ITEM, (Accessory)COLLAR_ITEM);
        for (int i = 0; i < PAWS_DYE_COLORS.length; ++i) {
            class_1767 c = PAWS_DYE_COLORS[i];
            class_5321<class_1792> itemKey = PawsItem.getRegistryKey(c);
            PlayerCollarsMod.PAWS_ITEMS[i] = (PawsItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, itemKey, (Object)((Object)new PawsItem(itemKey, c.method_7790(), 15832783))));
            itemKey = FootPawsItem.getRegistryKey(c);
            PlayerCollarsMod.FOOT_PAWS_ITEMS[i] = (FootPawsItem)((Object)class_2378.method_39197((class_2378)class_7923.field_41178, itemKey, (Object)((Object)new FootPawsItem(itemKey, c.method_7790(), 15832783))));
        }
        for (class_1767 c : class_1767.values()) {
            class_5321<class_2248> blockKey = DogBedBlock.getRegistryKey(c);
            PlayerCollarsMod.DOG_BEDS[c.ordinal()] = (DogBedBlock)((Object)class_2378.method_39197((class_2378)class_7923.field_41175, blockKey, (Object)((Object)new DogBedBlock(c, blockKey))));
            class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)blockKey.method_29177());
            PlayerCollarsMod.DOG_BED_ITEMS[c.ordinal()] = (class_1748)class_2378.method_39197((class_2378)class_7923.field_41178, (class_5321)itemKey, (Object)new class_1748((class_2248)DOG_BEDS[c.ordinal()], new class_1792.class_1793().method_7889(1).method_63686(itemKey)));
        }
        PlayerBlockBreakEvents.BEFORE.register((var1, player, blockPos, var4, var5) -> {
            class_1532 knot;
            if (var1.field_9236) {
                return true;
            }
            if (player.method_7325()) {
                return true;
            }
            class_1297 leashHolderEntity = ((LeashImpl)player).leashplayers$getProxyLeashHolder();
            if (leashHolderEntity instanceof class_1532 && blockPos.equals((Object)(knot = (class_1532)leashHolderEntity).method_59940())) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.playercollars.no_break_fence").method_27692(class_124.field_1061), true);
                return false;
            }
            return true;
        });
        AttackEntityCallback.EVENT.register((player, var2, var3, var4, var5) -> {
            class_1297 leashedEnt;
            if (var2.field_9236) {
                return class_1269.field_5811;
            }
            if (player.method_7325()) {
                return class_1269.field_5811;
            }
            AccessoriesCapability cap = AccessoriesCapability.get((class_1309)player);
            if (cap != null) {
                for (SlotEntryReference sr : cap.getEquipped(x -> x.method_31573(COLLAR_TAG))) {
                    OwnerComponent owner = (OwnerComponent)sr.stack().method_57824(OWNER_COMPONENT_TYPE);
                    if (owner == null || !owner.uuid().equals(var4.method_5667())) continue;
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.playercollars.no_attack_owner").method_27692(class_124.field_1061), true);
                    double f = player.method_45325(class_5134.field_23721);
                    f = (f - 1.0) * 0.75 + 1.0;
                    player.method_64397((class_3218)var2, player.method_48923().method_48802(player), (float)Math.ceil(f));
                    return class_1269.field_5811;
                }
            }
            if ((leashedEnt = ((LeashImpl)player).leashplayers$getProxyLeashHolder()) instanceof class_1532 && leashedEnt.equals((Object)var4)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.playercollars.no_break_fence").method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    static {
        PAWS_BLOCK_CONFIG_SCREEN_HANDLER = new ExtendedScreenHandlerType(PawsConfigScreenHandler.PawsBlockConfigScreenHandler::new, class_9135.method_56368(CAN_INTERACT_COMPONENT_CODEC));
        PAWS_ITEM_CONFIG_SCREEN_HANDLER = new ExtendedScreenHandlerType(PawsConfigScreenHandler.PawsItemConfigScreenHandler::new, class_9135.method_56368(HELD_ITEMS_COMPONENT_CODEC));
        for (class_1767 c : class_1767.values()) {
            class_5321<class_2248> blockKey = DogBowlBlock.getRegistryKey(c);
            PlayerCollarsMod.DOG_BOWLS[c.ordinal()] = (DogBowlBlock)((Object)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)blockKey.method_29177(), (Object)((Object)new DogBowlBlock(c, class_4970.class_2251.method_9637().method_9626(class_2498.field_11544).method_9632(0.6f).method_22488().method_50012(class_3619.field_15971).method_63500(blockKey)))));
            class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)blockKey.method_29177());
            PlayerCollarsMod.DOG_BOWL_ITEMS[c.ordinal()] = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)itemKey.method_29177(), (Object)new class_1747((class_2248)DOG_BOWLS[c.ordinal()], new class_1792.class_1793().method_63686(itemKey)));
        }
        DOG_BOWL_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"dog_bowl"), (Object)FabricBlockEntityTypeBuilder.create(DogBowlBlock.DogBowlBlockEntity::new, (class_2248[])DOG_BOWLS).build());
        GROUP = (class_1761)class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"group"), (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.playercollars")).method_47320(() -> ((CollarItem)COLLAR_ITEM).method_7854()).method_47317((displayContext, entries) -> {
            entries.method_45421((class_1935)COLLAR_ITEM);
            entries.method_45421((class_1935)TAGLESS_COLLAR_ITEM);
            entries.method_45421((class_1935)CLICKER_ITEM);
            entries.method_45421((class_1935)COLLAR_LOCKER_ITEM);
            entries.method_45421((class_1935)PAW_CONFIGURATION_ITEM);
            for (PawsItem pawsItem : PAWS_ITEMS) {
                entries.method_45421((class_1935)pawsItem);
            }
            for (FootPawsItem footPawsItem : FOOT_PAWS_ITEMS) {
                entries.method_45421((class_1935)footPawsItem);
            }
            entries.method_45421((class_1935)DEED_OF_OWNERSHIP);
            entries.method_45421((class_1935)SPATULA_ITEM);
            for (FootPawsItem footPawsItem : DOG_BED_ITEMS) {
                entries.method_45421((class_1935)footPawsItem);
            }
            for (FootPawsItem footPawsItem : DOG_BOWL_ITEMS) {
                entries.method_45421((class_1935)footPawsItem);
            }
            entries.method_45421((class_1935)INVISIBLE_FENCE_BLOCK_ITEM);
        }).method_47324());
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"paws_block_config"), PAWS_BLOCK_CONFIG_SCREEN_HANDLER);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"paws_item_config"), PAWS_ITEM_CONFIG_SCREEN_HANDLER);
    }
}

