/*
 * Decompiled with CFR 0.152.
 */
package org.jlortiz.playercollars.mixin;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import net.fabricmc.fabric.api.tag.convention.v2.TagUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9886;
import org.jetbrains.annotations.Nullable;
import org.jlortiz.playercollars.PlayerCollarsMod;
import org.jlortiz.playercollars.item.PawsItem;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    @Shadow
    @Final
    class_1661 field_7514;

    @Shadow
    @Nullable
    public abstract class_1542 method_7328(class_1799 var1, boolean var2);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Redirect(method={"getBlockBreakingSpeed"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;getBlockBreakingSpeed(Lnet/minecraft/block/BlockState;)F"))
    private float getBlockBreakingSpeed(class_1661 instance, class_2680 block) {
        float ret = instance.method_7370(block);
        AccessoriesCapability cap = AccessoriesCapability.get((class_1309)this);
        if (cap == null) {
            return ret;
        }
        if (cap.getEquipped(x -> x.method_31573(PlayerCollarsMod.PAWS_TAG)).isEmpty()) {
            return ret;
        }
        if (TagUtil.isIn((class_6862)class_3481.field_33716, (Object)block.method_26204())) {
            return class_9886.field_52587.comp_2932();
        }
        return (ret - 1.0f) * 0.125f + 1.0f;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttributeValue(Lnet/minecraft/registry/entry/RegistryEntry;)D", ordinal=0))
    private double getAttributeValue(class_1657 instance, class_6880<class_1320> registryEntry) {
        double ret = instance.method_45325(registryEntry);
        AccessoriesCapability cap = AccessoriesCapability.get((class_1309)this);
        if (cap == null) {
            return ret;
        }
        if (cap.getEquipped(x -> x.method_31573(PlayerCollarsMod.PAWS_TAG)).isEmpty()) {
            return ret;
        }
        return (ret - 1.0) * 0.75 + 1.0;
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void playercollars$addAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(PlayerCollarsMod.ATTR_LEASH_DISTANCE).method_26867(PlayerCollarsMod.ATTR_CLICKER_DISTANCE);
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;updateItems()V", shift=At.Shift.AFTER)})
    private void playercollars$dropPawItems(CallbackInfo ci) {
        AccessoriesCapability cap = AccessoriesCapability.get((class_1309)this);
        if (cap == null) {
            return;
        }
        for (SlotEntryReference sr : cap.getEquipped(x -> x.method_31573(PlayerCollarsMod.PAWS_TAG))) {
            class_1799 stack;
            if (PawsItem.shouldDrop(sr.stack(), this.field_7514.method_7391()) && !(stack = this.field_7514.method_37417(true)).method_7960()) {
                this.method_7328(stack, true);
            }
            if (!PawsItem.shouldDrop(sr.stack(), this.field_7514.method_5438(40)) || (stack = this.field_7514.method_5441(40)).method_7960()) continue;
            this.method_7328(stack, true);
        }
    }

    @Redirect(method={"updatePose"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setPose(Lnet/minecraft/entity/EntityPose;)V"))
    private void playercollars$forceCrawl(class_1657 instance, class_4050 entityPose) {
        AccessoriesCapability cap;
        if (!(instance.method_31549().field_7479 || entityPose != class_4050.field_18081 && entityPose != class_4050.field_18076 || (cap = AccessoriesCapability.get((class_1309)this)) == null || cap.getEquipped(x -> x.method_31573(PlayerCollarsMod.FOOT_PAWS_TAG)).isEmpty())) {
            entityPose = class_4050.field_18079;
        }
        instance.method_18380(entityPose);
    }
}

