/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms.block.renderer;

import com.khazoda.heirlooms.block.DisplayRackBlock;
import com.khazoda.heirlooms.block.DisplayRackBlockEntity;
import com.khazoda.heirlooms.block.renderer.DisplayRackRenderState;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Quaternionfc;

public class DisplayRackRenderer
implements class_827<DisplayRackBlockEntity, DisplayRackRenderState> {
    private final class_10442 itemModelResolver;
    private static final Object2BooleanMap<class_2248> BLOCK_COLLISION_CACHE = new Object2BooleanOpenHashMap();

    public DisplayRackRenderer(class_5614.class_5615 context) {
        this.itemModelResolver = context.comp_4536();
    }

    public DisplayRackRenderState createRenderState() {
        return new DisplayRackRenderState();
    }

    public void extractRenderState(DisplayRackBlockEntity blockEntity, DisplayRackRenderState renderState, float partialTick, class_243 cameraPosition, class_11683.class_11792 breakProgress) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPosition, breakProgress);
        renderState.facing = (class_2350)blockEntity.method_11010().method_11654(DisplayRackBlock.FACING);
        renderState.renderedBlockState = null;
        renderState.item = null;
        renderState.isBlockItem = false;
        class_1799 stack = blockEntity.method_5438(0);
        if (!stack.method_7960()) {
            class_1747 blockItem;
            class_2248 block;
            boolean isFullBlock;
            boolean useBlockRender = false;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747 && (isFullBlock = BLOCK_COLLISION_CACHE.computeIfAbsent((Object)(block = (blockItem = (class_1747)class_17922).method_7711()), b -> {
                class_2680 state = b.method_9564();
                if (blockEntity.method_10997() != null) {
                    return state.method_26234((class_1922)blockEntity.method_10997(), blockEntity.method_11016());
                }
                return false;
            }))) {
                renderState.renderedBlockState = block.method_9564();
                useBlockRender = true;
            }
            if (!useBlockRender) {
                renderState.item = new class_10444();
                this.itemModelResolver.method_65598(renderState.item, stack, class_811.field_4319, blockEntity.method_10997(), null, 0);
            }
            renderState.isBlockItem = useBlockRender;
        }
    }

    public void submit(DisplayRackRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        if (renderState.renderedBlockState == null && renderState.item == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.facing.method_10144() + 180.0f));
        if (renderState.renderedBlockState != null) {
            poseStack.method_22904(0.0, -0.04, -0.05);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(22.5f));
            float scale = 0.3f;
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            nodeCollector.method_73481(poseStack, renderState.renderedBlockState, renderState.field_62676, class_4608.field_21444, 0);
        } else if (renderState.item != null) {
            poseStack.method_22904(0.0, -0.05, 0.05);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(22.5f));
            float scale = 0.725f;
            poseStack.method_22905(scale, scale, scale);
            renderState.item.method_65604(poseStack, nodeCollector, renderState.field_62676, class_4608.field_21444, 0);
        }
        poseStack.method_22909();
    }
}

