/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms;

import com.khazoda.heirlooms.HeirloomsMod;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class CommonTooltipHandler {
    public static final int CRAFTED_TEXT_COLOR = 9068607;
    public static final int ENCHANTED_TEXT_COLOR = 4157834;

    public static void handleTooltip(class_1799 stack, List<class_2561> tooltip, class_1836 flag, boolean isCtrlPressed, boolean isAltPressed) {
        String craftedTimestamp = (String)stack.method_57824(HeirloomsMod.CRAFTED_TIMESTAMP);
        String craftedBy = (String)stack.method_57824(HeirloomsMod.CRAFTED_BY);
        String enchantedTimestamp = (String)stack.method_57824(HeirloomsMod.ENCHANTED_TIMESTAMP);
        String enchantedBy = (String)stack.method_57824(HeirloomsMod.ENCHANTED_BY);
        if (craftedTimestamp == null && enchantedTimestamp == null) {
            return;
        }
        CommonTooltipHandler.addButtonPrompts(tooltip, craftedTimestamp != null, enchantedTimestamp != null, isCtrlPressed, isAltPressed);
        if (craftedTimestamp != null && craftedBy != null && isCtrlPressed) {
            CommonTooltipHandler.addTimestampTooltip(tooltip, craftedTimestamp, craftedBy, "tooltip.heirlooms.crafted_by", 9068607);
        }
        if (enchantedTimestamp != null && enchantedBy != null && isAltPressed) {
            CommonTooltipHandler.addTimestampTooltip(tooltip, enchantedTimestamp, enchantedBy, "tooltip.heirlooms.enchanted_by", 4157834);
        }
    }

    private static void addButtonPrompts(List<class_2561> tooltip, boolean hasCraftData, boolean hasEnchantData, boolean isCtrlPressed, boolean isAltPressed) {
        class_5250 buttonPrompt = class_2561.method_43473();
        if (hasCraftData && !isCtrlPressed) {
            buttonPrompt.method_10852((class_2561)class_2561.method_43470((String)"[\u1d04\u1d1b\u0280\u029f]").method_54663(9068607));
        }
        if (hasCraftData && !isCtrlPressed && hasEnchantData && !isAltPressed) {
            buttonPrompt.method_10852((class_2561)class_2561.method_43470((String)" "));
        }
        if (hasEnchantData && !isAltPressed) {
            buttonPrompt.method_10852((class_2561)class_2561.method_43470((String)"[\u1d00\u029f\u1d1b]").method_54663(4157834));
        }
        if (!buttonPrompt.getString().isEmpty()) {
            tooltip.add((class_2561)buttonPrompt);
        }
    }

    private static void addTimestampTooltip(List<class_2561> tooltip, String timestamp, String creator, String translationKey, int color) {
        try {
            Instant instant = Instant.parse(timestamp);
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
            int year = zonedDateTime.getYear();
            int month = zonedDateTime.getMonthValue();
            int day = zonedDateTime.getDayOfMonth();
            String languageCode = class_310.method_1551().method_1526().method_4669();
            Locale locale = Locale.forLanguageTag(languageCode.replace("_", "-"));
            String monthName = zonedDateTime.getMonth().getDisplayName(TextStyle.FULL, locale);
            tooltip.add((class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{creator}).method_54663(color));
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.heirlooms.date", (Object[])new Object[]{CommonTooltipHandler.getFormattedDay(day, locale), month, monthName, year}).method_54663(color));
        }
        catch (Exception e) {
            System.out.println("Heirlooms mod error [1] - please report on the issue tracker");
        }
    }

    private static String getFormattedDay(int day, Locale locale) {
        if (locale.getLanguage().equals("en")) {
            String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
            return switch (day % 100) {
                case 11, 12, 13 -> day + "th";
                default -> day + suffixes[day % 10];
            };
        }
        return String.valueOf(day);
    }
}

