/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms;

import com.khazoda.heirlooms.HeirloomsMod;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="heirlooms")
public class TooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        String monthName;
        Locale locale;
        String languageCode;
        int day;
        int month;
        int year;
        ZonedDateTime zonedDateTime;
        Instant instant;
        boolean existsEnchantData;
        ItemStack stack = event.getItemStack();
        List list = event.getToolTip();
        String crafted_timestamp = (String)stack.get(HeirloomsMod.CRAFTED_TIMESTAMP);
        String crafted_by = (String)stack.get(HeirloomsMod.CRAFTED_BY);
        int craftedTextColour = 9068607;
        String enchanted_timestamp = (String)stack.get(HeirloomsMod.ENCHANTED_TIMESTAMP);
        String enchanted_by = (String)stack.get(HeirloomsMod.ENCHANTED_BY);
        int enchantedTextColour = 4157834;
        if (crafted_timestamp == null && enchanted_timestamp == null) {
            return;
        }
        MutableComponent buttonPrompt = Component.empty();
        boolean pressedCTRL = Screen.hasControlDown();
        boolean pressedALT = Screen.hasAltDown();
        boolean existsCraftData = crafted_timestamp != null;
        boolean bl = existsEnchantData = enchanted_timestamp != null;
        if (existsCraftData && !pressedCTRL) {
            buttonPrompt.append((Component)Component.literal((String)"[\u1d04\u1d1b\u0280\u029f]").withColor(craftedTextColour));
        }
        if (existsCraftData && !pressedCTRL && existsEnchantData && !pressedALT) {
            buttonPrompt.append((Component)Component.literal((String)" "));
        }
        if (existsEnchantData && !pressedALT) {
            buttonPrompt.append((Component)Component.literal((String)"[\u1d00\u029f\u1d1b]").withColor(enchantedTextColour));
        }
        if (!buttonPrompt.getString().isEmpty()) {
            list.add(buttonPrompt);
        }
        if (crafted_timestamp != null && crafted_by != null) {
            try {
                if (Screen.hasControlDown()) {
                    instant = Instant.parse(crafted_timestamp);
                    zonedDateTime = instant.atZone(ZoneId.systemDefault());
                    year = zonedDateTime.getYear();
                    month = zonedDateTime.getMonthValue();
                    day = zonedDateTime.getDayOfMonth();
                    languageCode = Minecraft.getInstance().getLanguageManager().getSelected();
                    locale = Locale.forLanguageTag(languageCode.replace("_", "-"));
                    monthName = zonedDateTime.getMonth().getDisplayName(TextStyle.FULL, locale);
                    list.add(Component.translatable((String)"tooltip.heirlooms.crafted_by", (Object[])new Object[]{crafted_by}).withColor(craftedTextColour));
                    list.add(Component.translatable((String)"tooltip.heirlooms.date", (Object[])new Object[]{day, month, monthName, year}).withColor(craftedTextColour));
                }
            }
            catch (Exception ignored) {
                System.out.println("Heirlooms mod error [1] - please report on the issue tracker");
            }
        }
        if (enchanted_timestamp != null && enchanted_by != null) {
            try {
                if (Screen.hasAltDown()) {
                    instant = Instant.parse(enchanted_timestamp);
                    zonedDateTime = instant.atZone(ZoneId.systemDefault());
                    year = zonedDateTime.getYear();
                    month = zonedDateTime.getMonthValue();
                    day = zonedDateTime.getDayOfMonth();
                    languageCode = Minecraft.getInstance().getLanguageManager().getSelected();
                    locale = Locale.forLanguageTag(languageCode.replace("_", "-"));
                    monthName = zonedDateTime.getMonth().getDisplayName(TextStyle.FULL, locale);
                    list.add(Component.translatable((String)"tooltip.heirlooms.enchanted_by", (Object[])new Object[]{enchanted_by}).withColor(enchantedTextColour));
                    list.add(Component.translatable((String)"tooltip.heirlooms.date", (Object[])new Object[]{day, month, monthName, year}).withColor(enchantedTextColour));
                }
            }
            catch (Exception ignored) {
                System.out.println("Heirlooms mod error [1] - please report on the issue tracker");
            }
        }
    }
}

