/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms;

import com.khazoda.heirlooms.HeirloomsMod;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="heirlooms")
public class TooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        String timestamp = (String)stack.get(HeirloomsMod.CRAFTED_TIMESTAMP);
        String crafted_by = (String)stack.get(HeirloomsMod.CRAFTED_BY);
        if (timestamp == null) {
            return;
        }
        if (crafted_by == null) {
            return;
        }
        try {
            if (!Screen.hasControlDown()) {
                event.getToolTip().add(Component.literal((String)"[\u1d04\u1d1b\u0280\u029f]").withColor(0x676767));
            } else {
                Instant instant = Instant.parse(timestamp);
                ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                int year = zonedDateTime.getYear();
                int month = zonedDateTime.getMonthValue();
                int day = zonedDateTime.getDayOfMonth();
                String languageCode = Minecraft.getInstance().getLanguageManager().getSelected();
                Locale locale = Locale.forLanguageTag(languageCode.replace("_", "-"));
                String monthName = zonedDateTime.getMonth().getDisplayName(TextStyle.FULL, locale);
                event.getToolTip().add(Component.translatable((String)"tooltip.heirlooms.crafted_by", (Object[])new Object[]{crafted_by}).withColor(0x676767));
                event.getToolTip().add(Component.translatable((String)"tooltip.heirlooms.crafted_date", (Object[])new Object[]{day, month, monthName, year}).withColor(0x676767));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

