/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms.block;

import com.khazoda.heirlooms.block.DisplayRackBlockEntity;
import com.khazoda.heirlooms.block.util.VoxelShapeHelper;
import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplayRackBlock
extends BaseEntityBlock {
    public static final MapCodec<DisplayRackBlock> CODEC = DisplayRackBlock.simpleCodec(DisplayRackBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    final VoxelShape blockShape = this.makeShape();
    final VoxelShape[] blockShapes = VoxelShapeHelper.calculateBlockShapes(this.blockShape);

    public DisplayRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplayRackBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        return VoxelShapeHelper.getSidedOutlineShape(direction, this.blockShape, this.blockShapes);
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.4375, (double)0.75, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplayRackBlockEntity) {
            DisplayRackBlockEntity displayRack = (DisplayRackBlockEntity)blockEntity;
            return displayRack.getItem(0).isEmpty() ? 0 : 15;
        }
        return 0;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplayRackBlockEntity) {
            DisplayRackBlockEntity displayRack = (DisplayRackBlockEntity)blockEntity;
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack currentItem = displayRack.getItem(0);
            if (currentItem.isEmpty() && !stack.isEmpty()) {
                ItemStack itemToInsert = stack.split(1);
                displayRack.setItem(0, itemToInsert);
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!currentItem.isEmpty()) {
                ItemStack handStack = player.getItemInHand(hand);
                if (handStack.isEmpty()) {
                    player.setItemInHand(hand, currentItem);
                    displayRack.setItem(0, ItemStack.EMPTY);
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    ItemStack toPlace = handStack.split(1);
                    displayRack.setItem(0, toPlace);
                    if (handStack.isEmpty()) {
                        player.setItemInHand(hand, currentItem);
                    } else if (!player.getInventory().add(currentItem)) {
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)currentItem);
                    }
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ROTATE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void onExplosionHit(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        this.dropBlockContents((Level)level, pos);
        super.onExplosionHit(state, level, pos, explosion, dropConsumer);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.dropBlockContents(level, pos);
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    private void dropBlockContents(Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayRackBlockEntity) {
            DisplayRackBlockEntity displayRack = (DisplayRackBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)displayRack);
            displayRack.clearContent();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public boolean skipRendering(BlockState state, BlockState neighborState, Direction side) {
        return neighborState.is((Block)this) || super.skipRendering(state, neighborState, side);
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }
}

