/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms.block.renderer;

import com.khazoda.heirlooms.block.DisplayCaseBlock;
import com.khazoda.heirlooms.block.DisplayCaseBlockEntity;
import com.khazoda.heirlooms.block.renderer.DisplayCaseRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity, DisplayCaseRenderState> {
    private final ItemModelResolver itemModelResolver;
    private static final Quaternionf[] ROTATIONS = new Quaternionf[4];

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public DisplayCaseRenderState createRenderState() {
        return new DisplayCaseRenderState();
    }

    public void extractRenderState(DisplayCaseBlockEntity blockEntity, DisplayCaseRenderState renderState, float partialTick, Vec3 cameraPosition, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue(DisplayCaseBlock.FACING);
        renderState.renderedBlockState = null;
        renderState.item = null;
        ItemStack stack = blockEntity.getItem(0);
        if (!stack.isEmpty()) {
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                renderState.renderedBlockState = blockItem.getBlock().defaultBlockState();
            } else {
                renderState.item = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(renderState.item, stack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
            }
        }
    }

    public void submit(DisplayCaseRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.renderedBlockState == null && renderState.item == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (renderState.renderedBlockState != null) {
            poseStack.translate(0.0, 0.12, 0.0);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.facing.toYRot() + 180.0f));
            float scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            nodeCollector.submitBlock(poseStack, renderState.renderedBlockState, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        } else if (renderState.item != null) {
            poseStack.translate(0.0, -0.11, 0.0);
            int dirIndex = renderState.facing.get2DDataValue();
            if (dirIndex >= 0 && dirIndex < 4) {
                poseStack.mulPose((Quaternionfc)ROTATIONS[dirIndex]);
            } else {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.facing.toYRot() + 180.0f));
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            }
            float scale = 0.5f;
            poseStack.scale(scale, scale, scale);
            renderState.item.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        poseStack.popPose();
    }

    static {
        DisplayCaseRenderer.ROTATIONS[0] = Axis.YP.rotationDegrees(0.0f).mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        DisplayCaseRenderer.ROTATIONS[1] = Axis.YP.rotationDegrees(90.0f).mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        DisplayCaseRenderer.ROTATIONS[2] = Axis.YP.rotationDegrees(180.0f).mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        DisplayCaseRenderer.ROTATIONS[3] = Axis.YP.rotationDegrees(270.0f).mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
    }
}

