/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms.block.renderer;

import com.khazoda.heirlooms.block.DisplayRackBlock;
import com.khazoda.heirlooms.block.DisplayRackBlockEntity;
import com.khazoda.heirlooms.block.renderer.DisplayRackRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DisplayRackRenderer
implements BlockEntityRenderer<DisplayRackBlockEntity, DisplayRackRenderState> {
    private final ItemModelResolver itemModelResolver;
    private static final Object2BooleanMap<Block> BLOCK_COLLISION_CACHE = new Object2BooleanOpenHashMap();

    public DisplayRackRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public DisplayRackRenderState createRenderState() {
        return new DisplayRackRenderState();
    }

    public void extractRenderState(DisplayRackBlockEntity blockEntity, DisplayRackRenderState renderState, float partialTick, Vec3 cameraPosition, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue(DisplayRackBlock.FACING);
        renderState.renderedBlockState = null;
        renderState.item = null;
        renderState.isBlockItem = false;
        ItemStack stack = blockEntity.getItem(0);
        if (!stack.isEmpty()) {
            BlockItem blockItem;
            Block block;
            boolean isFullBlock;
            boolean useBlockRender = false;
            Item item = stack.getItem();
            if (item instanceof BlockItem && (isFullBlock = BLOCK_COLLISION_CACHE.computeIfAbsent((Object)(block = (blockItem = (BlockItem)item).getBlock()), b -> {
                BlockState state = b.defaultBlockState();
                if (blockEntity.getLevel() != null) {
                    return state.isCollisionShapeFullBlock((BlockGetter)blockEntity.getLevel(), blockEntity.getBlockPos());
                }
                return false;
            }))) {
                renderState.renderedBlockState = block.defaultBlockState();
                useBlockRender = true;
            }
            if (!useBlockRender) {
                renderState.item = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(renderState.item, stack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
            }
            renderState.isBlockItem = useBlockRender;
        }
    }

    public void submit(DisplayRackRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.renderedBlockState == null && renderState.item == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.facing.toYRot() + 180.0f));
        if (renderState.renderedBlockState != null) {
            poseStack.translate(0.0, -0.04, -0.05);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(22.5f));
            float scale = 0.3f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            nodeCollector.submitBlock(poseStack, renderState.renderedBlockState, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        } else if (renderState.item != null) {
            poseStack.translate(0.0, -0.05, 0.05);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(22.5f));
            float scale = 0.725f;
            poseStack.scale(scale, scale, scale);
            renderState.item.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        poseStack.popPose();
    }
}

