/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.heirlooms.mixin;

import com.khazoda.heirlooms.CommonTooltipHandler;
import com.khazoda.heirlooms.block.DisplayCaseBlockEntity;
import com.khazoda.heirlooms.block.DisplayRackBlockEntity;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class ClientMixinGUI {
    @Unique
    private final Minecraft heirlooms$minecraft = Minecraft.getInstance();
    @Unique
    private static final int ORIGINAL_BROWN = 9068607;
    @Unique
    private static final int ORIGINAL_BLUE = 4157834;
    @Unique
    private static final int HUD_GOLD = 16765565;
    @Unique
    private static final int HUD_SKY = 9096939;

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        if (this.heirlooms$minecraft.options.hideGui || this.heirlooms$minecraft.player == null || this.heirlooms$minecraft.level == null) {
            return;
        }
        HitResult hitResult = this.heirlooms$minecraft.hitResult;
        if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK) {
            DisplayRackBlockEntity displayRack;
            ItemStack stack;
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.getBlockPos();
            BlockEntity be = this.heirlooms$minecraft.level.getBlockEntity(pos);
            if (be instanceof DisplayCaseBlockEntity) {
                DisplayCaseBlockEntity displayCase = (DisplayCaseBlockEntity)be;
                ItemStack stack2 = displayCase.getItem(0);
                if (!stack2.isEmpty()) {
                    this.heirlooms$renderHudExtras(guiGraphics, stack2);
                }
            } else if (be instanceof DisplayRackBlockEntity && !(stack = (displayRack = (DisplayRackBlockEntity)be).getItem(0)).isEmpty()) {
                this.heirlooms$renderHudExtras(guiGraphics, stack);
            }
        }
    }

    @Unique
    private void heirlooms$renderHudExtras(GuiGraphics guiGraphics, ItemStack stack) {
        Component name = stack.getHoverName();
        ArrayList<Component> dataLines = new ArrayList<Component>();
        CommonTooltipHandler.handleTooltip(stack, dataLines, (TooltipFlag)TooltipFlag.NORMAL, true, true);
        for (int i = 0; i < dataLines.size(); ++i) {
            Component line = (Component)dataLines.get(i);
            TextColor color = line.getStyle().getColor();
            if (color == null) continue;
            if (color.getValue() == 9068607) {
                dataLines.set(i, (Component)line.copy().withColor(16765565));
                continue;
            }
            if (color.getValue() != 4157834) continue;
            dataLines.set(i, (Component)line.copy().withColor(9096939));
        }
        int screenWidth = this.heirlooms$minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.heirlooms$minecraft.getWindow().getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int startY = screenHeight / 2 + 35;
        int nameWidth = this.heirlooms$minecraft.font.width((FormattedText)name);
        int iconWidth = 16;
        int gap = 4;
        int totalWidth = iconWidth + gap + nameWidth;
        int groupStartX = centerX - totalWidth / 2;
        guiGraphics.renderItem(stack, groupStartX, startY - 4);
        guiGraphics.drawString(this.heirlooms$minecraft.font, name, groupStartX + iconWidth + gap, startY, -1, true);
        if (dataLines.isEmpty()) {
            return;
        }
        int baseDataY = startY + 18;
        if (dataLines.size() >= 4) {
            Component line;
            int i;
            int spineGap = 6;
            int currentY = baseDataY;
            for (i = 0; i < 2; ++i) {
                line = (Component)dataLines.get(i);
                int lineWidth = this.heirlooms$minecraft.font.width((FormattedText)line);
                guiGraphics.drawString(this.heirlooms$minecraft.font, line, centerX - spineGap - lineWidth, currentY, -1, true);
                Objects.requireNonNull(this.heirlooms$minecraft.font);
                currentY += 9 + 2;
            }
            currentY = baseDataY;
            for (i = 2; i < dataLines.size(); ++i) {
                line = (Component)dataLines.get(i);
                guiGraphics.drawString(this.heirlooms$minecraft.font, line, centerX + spineGap, currentY, -1, true);
                Objects.requireNonNull(this.heirlooms$minecraft.font);
                currentY += 9 + 2;
            }
        } else {
            int currentY = baseDataY;
            for (Component line : dataLines) {
                guiGraphics.drawCenteredString(this.heirlooms$minecraft.font, line, centerX, currentY, -1);
                Objects.requireNonNull(this.heirlooms$minecraft.font);
                currentY += 9 + 2;
            }
        }
    }
}

